/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.ui.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.ui.Activator;
import org.polarsys.kitalpha.resourcereuse.ui.Messages;

public class ResourceSearchDialog
extends Dialog {
    private final SearchCriteria criteria;
    private Text idText;
    private Text nameText;
    private Text versionText;
    private Text domainText;
    private final List<StringValue> tags = new ArrayList<StringValue>();
    private final List<StringValue> userConcerns = new ArrayList<StringValue>();
    private final List<StringValue> usedConcerns = new ArrayList<StringValue>();
    private final List<StringValue> involvedInConcerns = new ArrayList<StringValue>();

    public ResourceSearchDialog(Shell parentShell, SearchCriteria criteria) {
        super(parentShell);
        this.criteria = criteria;
        if (criteria == null) {
            throw new NullPointerException();
        }
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 450;
        layoutData.minimumWidth = 550;
        composite.setLayoutData((Object)layoutData);
        this.createResourceCriteriaComposite(composite);
        this.createConcernCriteriaComposite(composite);
        ResourceSearchDialog.applyDialogFont((Control)composite);
        composite.pack();
        this.getShell().setText(Messages.Search_dialog_title);
        return composite;
    }

    private void createConcernCriteriaComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.Concern_group_Label);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.userConcerns.addAll(this.toStringValueList(this.criteria.getUserInConcerns()));
        this.usedConcerns.addAll(this.toStringValueList(this.criteria.getUsedInConcerns()));
        this.involvedInConcerns.addAll(this.toStringValueList(this.criteria.getConcerns()));
        this.createTableComposite((Composite)group, this.userConcerns, "concern", Messages.Concern_userTable_Label, Messages.Concern_Field__AddButton_Label, Messages.Concern_Field__DeleteButton_Label);
        this.createTableComposite((Composite)group, this.usedConcerns, "concern", Messages.Concern_usedTable_Label, Messages.Concern_Field__AddButton_Label, Messages.Concern_Field__DeleteButton_Label);
        this.createTableComposite((Composite)group, this.involvedInConcerns, "concern", Messages.Concern_bothTable_Label, Messages.Concern_Field__AddButton_Label, Messages.Concern_Field__DeleteButton_Label);
    }

    private void createResourceCriteriaComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite fields = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        fields.setLayout((Layout)layout);
        fields.setLayoutData((Object)new GridData(1808));
        Label label = new Label(fields, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.id_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.idText = new Text(fields, 2048);
        this.idText.setLayoutData((Object)new GridData(768));
        this.idText.setText(this.toString(this.criteria.getId()));
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.name_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.nameText = new Text(fields, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.toString(this.criteria.getName()));
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.version_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.versionText = new Text(fields, 2048);
        this.versionText.setLayoutData((Object)new GridData(768));
        this.versionText.setText(this.toString(this.criteria.getVersion()));
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.domain_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.domainText = new Text(fields, 2048);
        this.domainText.setLayoutData((Object)new GridData(768));
        this.domainText.setText(this.toString(this.criteria.getDomain()));
        this.tags.addAll(this.toStringValueList(this.criteria.getTags()));
        this.createTableComposite(composite, this.tags, "newTag", String.valueOf(Messages.tags_Field_Label) + ':', Messages.tags_Field__AddButton_Label, Messages.tags_Field__DeleteButton_Label);
    }

    protected void createTableComposite(Composite parent, final List<StringValue> data, final String defaultValue, String tableLabel, String addLabel, String deleteLabel) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(tableLabel);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        final TableViewer viewer = new TableViewer(composite);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setColumnProperties(new String[]{"name"});
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)viewer.getTable())});
        viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                StringValue tag = (StringValue)((TableItem)element).getData();
                tag.value = value.toString();
                viewer.refresh();
            }

            public Object getValue(Object element, String property) {
                StringValue tag = (StringValue)element;
                return tag.value;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        viewer.setInput(data);
        Composite btnComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        btnComposite.setLayout((Layout)layout);
        btnComposite.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(btnComposite, 8);
        addButton.setLayoutData((Object)new GridData());
        addButton.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        addButton.setToolTipText(addLabel);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                data.add(new StringValue(defaultValue));
                viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button deleteButton = new Button(btnComposite, 8);
        deleteButton.setLayoutData((Object)new GridData());
        deleteButton.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        deleteButton.setToolTipText(deleteLabel);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    data.remove(obj);
                    ++n2;
                }
                viewer.refresh();
                deleteButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.Search_Button_Label, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.criteria.setId(this.idText.getText());
        this.criteria.setName(this.nameText.getText());
        this.criteria.setVersion(this.versionText.getText());
        this.criteria.setDomain(this.domainText.getText());
        this.criteria.getTags().clear();
        this.criteria.getTags().addAll(this.toStringList(this.tags));
        this.criteria.getConcerns().clear();
        this.criteria.getConcerns().addAll(this.toStringList(this.involvedInConcerns));
        this.criteria.getUsedInConcerns().clear();
        this.criteria.getUsedInConcerns().addAll(this.toStringList(this.usedConcerns));
        this.criteria.getUserInConcerns().clear();
        this.criteria.getUserInConcerns().addAll(this.toStringList(this.userConcerns));
        super.okPressed();
    }

    private Collection<String> toStringList(List<StringValue> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (StringValue value : list) {
            result.add(value.value);
        }
        return result;
    }

    private String toString(String value) {
        return value == null ? "" : value;
    }

    private List<StringValue> toStringValueList(List<String> tags) {
        ArrayList<StringValue> result = new ArrayList<StringValue>();
        for (String value : tags) {
            result.add(new StringValue(value));
        }
        return result;
    }

    private static class StringValue {
        public String value;

        public StringValue(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

