/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.ui.action;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.amalgam.explorer.contextual.core.ui.action.ExplorerContextualHistoryAction;
import org.eclipse.emf.ecore.EObject;

public class ExplorerHistory {
    private static final int MAX_SIZE = 10;
    private List<ExplorerContextualHistoryAction> _actionAsListeners;
    private int _currentEntryIndex = -1;
    private List<ExplorerNavigationHistoryEntry> _entries = new ArrayList<ExplorerNavigationHistoryEntry>(10);
    private boolean _shouldDoUpdate = true;

    public ExplorerHistory() {
        this._actionAsListeners = new ArrayList<ExplorerContextualHistoryAction>(2);
    }

    public void addActionAsListener(ExplorerContextualHistoryAction action_p) {
        this._actionAsListeners.add(action_p);
    }

    private void cleanDeadEntries() {
        Iterator<ExplorerNavigationHistoryEntry> iterator = this._entries.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ExplorerNavigationHistoryEntry historyEntry = iterator.next();
            if (!historyEntry.isValid()) {
                iterator.remove();
                if (this._currentEntryIndex == i) {
                    --this._currentEntryIndex;
                }
            }
            ++i;
        }
        if (this._currentEntryIndex >= this._entries.size()) {
            this._currentEntryIndex = this._entries.size() - 1;
        } else if (this._currentEntryIndex < 0) {
            this._currentEntryIndex = 0;
        }
    }

    public void dispose() {
        if (this._entries != null) {
            this._entries.clear();
            this._entries = null;
        }
        if (this._actionAsListeners != null) {
            this._actionAsListeners.clear();
            this._actionAsListeners = null;
        }
        this._currentEntryIndex = -1;
    }

    public List<ExplorerNavigationHistoryEntry> getBackwardNavigationEntries() {
        List<ExplorerNavigationHistoryEntry> result = Collections.emptyList();
        if (!this._entries.isEmpty()) {
            result = new ArrayList<ExplorerNavigationHistoryEntry>(this._entries.subList(0, this._currentEntryIndex));
        }
        return result;
    }

    public List<ExplorerNavigationHistoryEntry> getForwardNavigationEntries() {
        List<ExplorerNavigationHistoryEntry> result = Collections.emptyList();
        if (this._currentEntryIndex < this._entries.size() - 1) {
            result = new ArrayList<ExplorerNavigationHistoryEntry>(this._entries.subList(this._currentEntryIndex + 1, this._entries.size()));
        }
        return result;
    }

    public void goTo(ExplorerNavigationHistoryEntry navigationEntry_p) {
        this._currentEntryIndex = this._entries.indexOf(navigationEntry_p);
    }

    protected void notifyActionListeners() {
        for (ExplorerContextualHistoryAction action : this._actionAsListeners) {
            action.updateControlState();
        }
    }

    public void setDoUpdate(boolean doUpdate_p) {
        this._shouldDoUpdate = doUpdate_p;
    }

    public void update(Object realObject_p) {
        this.cleanDeadEntries();
        if (this._shouldDoUpdate && realObject_p != null) {
            if (this._entries.size() == 10) {
                this._entries.remove(0);
            }
            this._entries.add(new ExplorerNavigationHistoryEntry(realObject_p));
            this._currentEntryIndex = this._entries.size() - 1;
        }
        this.notifyActionListeners();
    }

    protected class ExplorerNavigationHistoryEntry {
        private WeakReference<Object> _referencedObject;

        protected ExplorerNavigationHistoryEntry(Object realObject_p) {
            this._referencedObject = new WeakReference<Object>(realObject_p);
        }

        public Object getRealObject() {
            return this._referencedObject.get();
        }

        public boolean isValid() {
            boolean result = true;
            Object realObject = this.getRealObject();
            if (realObject == null || realObject instanceof EObject && ((EObject)realObject).eIsProxy()) {
                result = false;
            }
            return result;
        }
    }
}

