/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.explorer.contextual.reporter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.explorer.contextual.util.ClassUtils;

public class ContextualExplorerPluginXmlReporter
implements PatternExecutionReporter {
    private static final NullProgressMonitor Null_Progress_Monitor = new NullProgressMonitor();

    public void executionFinished(String output, PatternContext context) {
        String projectName = ClassUtils.INSTANCE.getProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            this.updatePluginXml(project, output);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void updatePluginXml(final IProject project, final String content) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                ByteArrayInputStream outputContent = new ByteArrayInputStream(content.getBytes());
                try {
                    IFile file = project.getFile("plugin.xml");
                    if (file.exists()) {
                        file.setContents((InputStream)outputContent, true, false, null);
                    } else {
                        file.create((InputStream)outputContent, true, null);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        operation.run((IProgressMonitor)Null_Progress_Monitor);
        try {
            project.refreshLocal(2, (IProgressMonitor)Null_Progress_Monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void loopFinished(String output, String outputWithCallBack, PatternContext context, Map<String, Object> parameterValues) {
    }
}

