/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonLabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public final class LogThroughActiveDialectEditorLogListener
implements ILogListener {
    public static final LogThroughActiveDialectEditorLogListener INSTANCE = new LogThroughActiveDialectEditorLogListener();
    private ICommonLabelProvider labelProvider;

    private LogThroughActiveDialectEditorLogListener() {
    }

    public void logging(IStatus status, String plugin) {
        boolean hasBeenLoggedThroughDialect = false;
        final Throwable exception = this.getFinalCause(status);
        if (SiriusEditPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusUIPreferencesKeys.PREF_REACT_TO_PERMISSION_ISSUES_BY_GRAPHICAL_DISPLAY.name())) {
            IEditorPart activeEditor;
            if (SiriusEditPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusUIPreferencesKeys.PREF_DISPLAY_PERMISSION_ISSUES_THROUGH_DIALOG.name()) && (activeEditor = EclipseUIUtil.getActiveEditor()) instanceof DialectEditor && this.shouldBeLoggedThroughDialect((DialectEditor)activeEditor, exception)) {
                ((DialectEditor)activeEditor).getDialogFactory().informUserOfEvent(4, this.getErrorMessage(exception));
                hasBeenLoggedThroughDialect = true;
            }
            if (!hasBeenLoggedThroughDialect && this.shouldBeLoggedThroughPopup(exception) && PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isStarting()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.LogThroughActiveDialectEditorLogListener_permissionError, (String)LogThroughActiveDialectEditorLogListener.this.getErrorMessage(exception));
                    }
                });
            }
        }
    }

    private Throwable getFinalCause(IStatus status) {
        Throwable exception = status.getException();
        while (exception != null && exception.getCause() != null) {
            exception = exception.getCause();
        }
        return exception;
    }

    private boolean shouldBeLoggedThroughDialect(DialectEditor editor, Throwable exception) {
        if (exception instanceof LockedInstanceException) {
            EObject lockedElement = ((LockedInstanceException)exception).getLockedElement();
            final DRepresentation activeRepresentation = editor.getRepresentation();
            boolean isConcerningObjectsOfCurrentEditor = false;
            if (lockedElement != null && activeRepresentation != null) {
                Session session = null;
                session = lockedElement instanceof DSemanticDecorator ? SessionManager.INSTANCE.getSession(((DSemanticDecorator)lockedElement).getTarget()) : SessionManager.INSTANCE.getSession(lockedElement);
                Iterable representationsElementsReferencingLockedElement = Iterables.filter((Iterable)session.getSemanticCrossReferencer().getInverseReferences(lockedElement), (Predicate)new Predicate<EStructuralFeature.Setting>(){

                    public boolean apply(EStructuralFeature.Setting input) {
                        if (input.getEObject() instanceof DSemanticDecorator) {
                            DRepresentation concernedRepresentation = null;
                            if (input.getEObject() instanceof DRepresentation) {
                                concernedRepresentation = (DRepresentation)input.getEObject();
                            } else if (input.getEObject() instanceof DRepresentationElement) {
                                concernedRepresentation = new DRepresentationElementQuery((DRepresentationElement)input.getEObject()).getParentRepresentation();
                            }
                            return concernedRepresentation == activeRepresentation;
                        }
                        return false;
                    }
                });
                isConcerningObjectsOfCurrentEditor = representationsElementsReferencingLockedElement.iterator().hasNext();
            }
            return isConcerningObjectsOfCurrentEditor;
        }
        return false;
    }

    private boolean shouldBeLoggedThroughPopup(Throwable exception) {
        boolean shouldBeLogged = false;
        boolean bl = shouldBeLogged = exception instanceof LockedInstanceException || exception instanceof SecurityException;
        if (shouldBeLogged) {
            String message = this.getErrorMessage(exception);
            shouldBeLogged = message != null && !message.isEmpty();
        }
        return shouldBeLogged;
    }

    private String getErrorMessage(Throwable exception) {
        EObject lockedElement;
        String errorMessage = exception.getMessage();
        if (exception instanceof LockedInstanceException && (lockedElement = ((LockedInstanceException)exception).getLockedElement()) != null) {
            errorMessage = MessageFormat.format(LockedInstanceException.PERMISSION_ISSUE_MESSAGE, this.getLabelProvider().getText((Object)lockedElement));
        }
        return errorMessage;
    }

    private ICommonLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new SiriusCommonLabelProvider();
        }
        return this.labelProvider;
    }
}

