/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.detachment.ui.contrib.unknownreferences.pages;

import java.util.Collection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.feedback.Feedback;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IFeedback;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.detachment.ui.contrib.unknownreferences.Messages;
import org.polarsys.kitalpha.model.detachment.ui.contrib.unknownreferences.providers.UnknownReferenceContentProvider;
import org.polarsys.kitalpha.model.detachment.ui.page.AbstractDetachmentFormPage;

public class UnknownReferencesPage
extends AbstractDetachmentFormPage {
    private TableViewer tableViewer;
    private Table table;
    private UnknownReferenceContentProvider contentProvider;

    public UnknownReferencesPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(Messages.UNKNOWN_REFERENCES);
        Composite composite = scrolledForm.getBody();
        composite.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer(composite, 67584);
        this.table = this.tableViewer.getTable();
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 140;
        this.table.setLayoutData((Object)gridData);
        new Label(composite, 0);
        new Label(composite, 0);
        this.contentProvider = new UnknownReferenceContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.contentProvider);
        ModelScrutinyRegistry.RegistryElement regElt = ModelScrutinyRegistry.INSTANCE.getRegistryElement(this.getFinderID());
        IFeedback unknownReferences = this.collectUnknownReferences(regElt);
        this.tableViewer.setInput((Object)unknownReferences);
    }

    private IFeedback collectUnknownReferences(ModelScrutinyRegistry.RegistryElement regElt) {
        Collection unknownRefFinders = regElt.getFinders();
        Feedback feedback = new Feedback();
        for (IScrutinize iFinder : unknownRefFinders) {
            Object feedBackResult = iFinder.getFeedbackAnalysisMessages();
            if (!(feedBackResult instanceof Collection)) continue;
            Collection messages = (Collection)feedBackResult;
            for (IFeedback.IFeedbackMessage fm : messages) {
                feedback.addFeedbackMessage(fm);
            }
        }
        return feedback;
    }
}

