/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConfigureContainerAction
implements IObjectActionDelegate {
    private ISelection fCurrentSelection;
    private IWorkbenchPart fPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fCurrentSelection instanceof IStructuredSelection) {
            ClassPathContainer container = (ClassPathContainer)((IStructuredSelection)this.fCurrentSelection).getFirstElement();
            this.openWizard(container.getClasspathEntry(), container.getLabel(), container.getJavaProject());
        }
    }

    private void openWizard(IClasspathEntry entry, String label, final IJavaProject project) {
        Shell shell = this.fPart.getSite().getShell();
        try {
            IClasspathEntry[] entries = project.getRawClasspath();
            IClasspathEntry result = BuildPathDialogAccess.configureContainerEntry(shell, entry, project, entries);
            if (result == null || result.equals(entry)) {
                return;
            }
            int idx = ConfigureContainerAction.indexInClasspath(entries, entry);
            if (idx == -1) {
                return;
            }
            final IClasspathEntry[] newEntries = new IClasspathEntry[entries.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[idx] = result;
            IWorkbenchWindow context = this.fPart.getSite().getWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.setRawClasspath(newEntries, project.getOutputLocation(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (JavaModelException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, message);
        }
        catch (InvocationTargetException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_applyingfailed_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected static int indexInClasspath(IClasspathEntry[] entries, IClasspathEntry entry) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i] == entry) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fCurrentSelection = selection;
    }
}

