/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesAssistContext;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesCorrectionAssistant;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditor;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;

public class PropertiesCorrectionProcessor
implements IQuickAssistProcessor {
    private String fErrorMessage;
    private SpellingCorrectionProcessor fSpellingCorrectionProcessor;
    private ICompletionProposal[] fPreComputedProposals;
    private final PropertiesCorrectionAssistant fAssistant;

    public PropertiesCorrectionProcessor(PropertiesCorrectionAssistant assistant) {
        this.fAssistant = assistant;
        this.fSpellingCorrectionProcessor = new SpellingCorrectionProcessor();
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        TextInvocationContext context = new TextInvocationContext(viewer, quickAssistContext.getOffset(), length);
        this.fErrorMessage = null;
        ICompletionProposal[] res = null;
        if (this.fPreComputedProposals != null) {
            res = this.fPreComputedProposals;
        } else {
            try {
                ICompletionProposal[] assists;
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                ICompletionProposal[] spellingProposals = this.fSpellingCorrectionProcessor.computeQuickAssistProposals(quickAssistContext);
                if (spellingProposals.length > 1) {
                    int i = 0;
                    while (i < spellingProposals.length) {
                        proposals.add(spellingProposals[i]);
                        ++i;
                    }
                }
                if ((assists = PropertiesQuickAssistProcessor.collectAssists(this.createAssistContext((IQuickAssistInvocationContext)context))) != null) {
                    int i = 0;
                    while (i < assists.length) {
                        proposals.add(assists[i]);
                        ++i;
                    }
                }
                res = proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
            catch (BadLocationException e) {
                this.fErrorMessage = PropertiesFileEditorMessages.PropertiesCorrectionProcessor_error_quickassist_message;
                JavaPlugin.log(e);
            }
            catch (BadPartitioningException e) {
                this.fErrorMessage = PropertiesFileEditorMessages.PropertiesCorrectionProcessor_error_quickassist_message;
                JavaPlugin.log(e);
            }
        }
        if (res == null || res.length == 0) {
            return new ICompletionProposal[]{new ChangeCorrectionProposal(PropertiesFileEditorMessages.PropertiesCorrectionProcessor_NoCorrectionProposal_description, (Change)new NullChange(""), 0, null)};
        }
        if (res.length > 1) {
            Arrays.sort(res, new CompletionProposalComparator());
        }
        this.fPreComputedProposals = null;
        return res;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean canFix(Annotation annotation) {
        return this.fSpellingCorrectionProcessor.canFix(annotation);
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return PropertiesQuickAssistProcessor.hasAssists(this.createAssistContext(invocationContext));
    }

    public void setProposals(ICompletionProposal[] preComputedProposals) {
        this.fPreComputedProposals = preComputedProposals;
    }

    private PropertiesAssistContext createAssistContext(IQuickAssistInvocationContext invocationContext) {
        IEditorPart editorPart = this.fAssistant.getEditor();
        IFile file = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
        ISourceViewer sourceViewer = invocationContext.getSourceViewer();
        IType accessorType = ((PropertiesFileEditor)editorPart).getAccessorType();
        return new PropertiesAssistContext(sourceViewer, invocationContext.getOffset(), invocationContext.getLength(), file, sourceViewer.getDocument(), accessorType);
    }
}

