/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.services.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.metadata.helpers.ViewpointMetadata;
import org.polarsys.kitalpha.ad.services.Activator;
import org.polarsys.kitalpha.ad.services.Messages;
import org.polarsys.kitalpha.ad.services.manager.AlreadyInStateException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ViewpointManager {
    private static final String VIEWPOINT_STATE_READ_ONLY = "stateReadOnly";
    private static final String VIEWPOINT_STATE_HIDDEN = "stateHidden";
    private static final String VIEWPOINT_STATE_MUTABLE_ACTIVATION = "stateMutableActivation";
    private static final List<OverallListener> overallListeners = new ArrayList<OverallListener>();
    private static final List<OverallListener2> overallListener2s = new ArrayList<OverallListener2>();
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<Listener2> listener2s = new ArrayList<Listener2>();
    private static final int REFERENCE = 16;
    private static final int UNREFERENCE = 32;
    private static final int ACTIVE = 64;
    private static final int INACTIVE = 128;
    private static final ViewpointManager nullManager = new NullViewpointManager();
    private static final Map<ResourceSet, ViewpointManager> instances = new HashMap<ResourceSet, ViewpointManager>();
    protected static ViewpointFinder VP_FINDER = new CachingFinder();
    private final Map<String, List<String>> dependencies = new HashMap<String, List<String>>();
    private final Set<String> managed = new HashSet<String>();
    private ResourceSet target;

    public static boolean canChangeState(String id) {
        Resource res = ViewpointManager.getViewpoint(id);
        return ViewpointManager.canChangeState(res);
    }

    public static boolean canChangeActivation(String id) {
        Resource res = ViewpointManager.getViewpoint(id);
        return ViewpointManager.canChangeActivation(res);
    }

    public static boolean canChangeState(Resource res) {
        return res != null && !res.getTags().contains(VIEWPOINT_STATE_READ_ONLY);
    }

    public static boolean canChangeActivation(Resource res) {
        return res != null && res.getTags().contains(VIEWPOINT_STATE_MUTABLE_ACTIVATION);
    }

    public void setTarget(ResourceSet target) {
        this.target = target;
    }

    public static Resource getViewpoint(String id) {
        Resource[] resourceArray = ViewpointManager.getAvailableViewpoints();
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            if (id.equals(res.getId())) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    public static void pinError(Resource vp, Exception e) {
        VP_FINDER.pinError(vp, e);
    }

    public static void pinError(Resource vp, String details) {
        VP_FINDER.pinError(vp, details);
    }

    /*
     * Unable to fully structure code
     */
    public static Description[] getAvailableViewpointDescriptions() {
        set = new ResourceSetImpl();
        result = new ArrayList<Description>();
        try {
            var5_2 = ViewpointManager.getAvailableViewpoints();
            var4_3 = var5_2.length;
            var3_4 = 0;
            while (var3_4 < var4_3) {
                resource = var5_2[var3_4];
                try {
                    uri = URIHelper.createURI((Resource)resource);
                    vp = (Viewpoint)set.getEObject(uri, true);
                    result.add(new Description(vp.getId(), vp.getName(), vp.getVersion(), resource));
                }
                catch (Exception e) {
                    ViewpointManager.pinError(resource, e);
                }
                ++var3_4;
            }
        }
        finally {
            ** for (r : set.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl24:
        // 1 sources

        set.getResources().clear();
        return result.toArray(new Description[result.size()]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version readVersion(Resource resource) {
        set = new ResourceSetImpl();
        try {
            var3_2 = ViewpointManager.readVersion((ResourceSet)set, resource);
            return var3_2;
        }
        finally {
            ** for (r : set.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl9:
        // 1 sources

        set.getResources().clear();
        return var3_2;
    }

    private static Version readVersion(ResourceSet set, Resource resource) {
        try {
            URI uri = URIHelper.createURI((Resource)resource);
            Viewpoint vp = (Viewpoint)set.getEObject(uri, true);
            return vp.getVersion();
        }
        catch (Exception e) {
            ViewpointManager.pinError(resource, e);
            return null;
        }
    }

    public static IStatus checkViewpointsCompliancy(ResourceSet context) {
        MultiStatus error = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 0, "Error with used viewpoints", null);
        ViewpointMetadata viewpointMetadata = MetadataHelper.getViewpointMetadata((ResourceSet)context);
        if (!viewpointMetadata.hasMetadata()) {
            URI uri = viewpointMetadata.getExpectedMetadataStorageURI();
            error.add((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Cannot find metadata resource: " + uri.toPlatformString(false)));
            return error;
        }
        Map<String, Version> availableViewpoints = ViewpointManager.computeAvailableViewpointVersions();
        Map viewpointUsages = viewpointMetadata.getViewpointReferences();
        for (Map.Entry usage : viewpointUsages.entrySet()) {
            IStatus res = ViewpointManager.useViewpoint(availableViewpoints, (String)usage.getKey(), (Version)usage.getValue());
            if (res.isOK()) continue;
            error.add(res);
        }
        if (!error.isOK()) {
            return error;
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkViewpointCompliancy(ResourceSet context, String vpId) {
        Map<String, Version> availableViewpoints = ViewpointManager.computeAvailableViewpointVersions();
        ViewpointMetadata viewpointMetadata = MetadataHelper.getViewpointMetadata((ResourceSet)context);
        Map viewpointUsages = viewpointMetadata.getViewpointReferences();
        if (viewpointUsages.containsKey(vpId)) {
            return ViewpointManager.useViewpoint(availableViewpoints, vpId, (Version)viewpointUsages.get(vpId));
        }
        return new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Not used viewpoint '" + vpId + "'");
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, Version> computeAvailableViewpointVersions() {
        availableViewpoints = new HashMap<String, Version>();
        set = new ResourceSetImpl();
        resource = null;
        try {
            var6_3 = ViewpointManager.getAvailableViewpoints();
            var5_4 = var6_3.length;
            var4_5 = 0;
            while (var4_5 < var5_4) {
                res = var6_3[var4_5];
                try {
                    resource = res;
                    uri = URIHelper.createURI((Resource)res);
                    vp = (Viewpoint)set.getEObject(uri, true);
                    if (vp == null) {
                        ViewpointManager.pinError(resource, "Cannot get object from " + uri.toString());
                    } else {
                        availableViewpoints.put(res.getId(), vp.getVersion());
                    }
                }
                catch (Exception e) {
                    ViewpointManager.pinError(resource, e);
                }
                ++var4_5;
            }
        }
        finally {
            ** for (r : set.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl29:
        // 1 sources

        set.getResources().clear();
        return availableViewpoints;
    }

    private static IStatus useViewpoint(Map<String, Version> availableViewpoints, String id, Version version) {
        for (Map.Entry<String, Version> res : availableViewpoints.entrySet()) {
            if (!res.getKey().equals(id)) continue;
            if (version == null || ViewpointManager.areEquivalentTo(version, res.getValue())) {
                return Status.OK_STATUS;
            }
            return new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Expecting version '" + version + "' for viewpoint '" + id + "' (current version: '" + res.getValue() + "')");
        }
        return new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Missing viewpoint '" + id + "'");
    }

    private static boolean areEquivalentTo(Version v1, Version v2) {
        if (v1 == null || v2 == null) {
            return true;
        }
        return v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor();
    }

    public static Resource[] getAvailableViewpoints() {
        return VP_FINDER.getAvailableViewpoints();
    }

    public boolean isActive(String id) {
        return this.isUsed(id) && !this.isFiltered(id);
    }

    public boolean isUsed(String id) {
        return this.isReferenced(id);
    }

    public boolean isReferenced(String id) {
        return MetadataHelper.getViewpointMetadata((ResourceSet)this.target).isReferenced(id);
    }

    public boolean isFiltered(String id) {
        return this.isInactive(id);
    }

    public boolean isInactive(String id) {
        return MetadataHelper.getViewpointMetadata((ResourceSet)this.target).isInactive(id);
    }

    public void filter(String id, boolean state) throws ViewpointActivationException {
        this.setActivationState(id, !state);
    }

    public void setActivationState(String id, boolean active) throws ViewpointActivationException {
        Resource vpResource = ViewpointManager.getViewpoint(id);
        if (vpResource == null) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_3, (Object)id));
        }
        if (!this.isReferenced(id)) {
            throw new AlreadyInStateException(NLS.bind((String)Messages.Viewpoint_Manager_error_4, (Object)id));
        }
        ChangeViewpointVisibilityCommand command = new ChangeViewpointVisibilityCommand(vpResource, active);
        this.executeCommand((Command)command);
    }

    public boolean hasMetadata() {
        return MetadataHelper.getViewpointMetadata((ResourceSet)this.target).hasMetadata();
    }

    public void activate(String id) throws ViewpointActivationException {
        this.reference(id);
    }

    public void startUse(String id) throws ViewpointActivationException {
        this.reference(id);
    }

    /*
     * Unable to fully structure code
     */
    public void reference(String id) throws ViewpointActivationException {
        vpResource = ViewpointManager.getViewpoint(id);
        if (vpResource == null) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_3, (Object)id));
        }
        if (this.isUsed(id)) {
            throw new AlreadyInStateException(NLS.bind((String)Messages.Viewpoint_Manager_error_4, (Object)id));
        }
        set = new ResourceSetImpl();
        try {
            this.doReference((ResourceSet)set, vpResource);
        }
        finally {
            ** for (r : set.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl14:
        // 1 sources

        set.getResources().clear();
    }

    protected void doReference(ResourceSet set, Resource vpResource) throws ViewpointActivationException {
        this.startBundle(vpResource);
        this.manageDependencies(set, vpResource);
        ReferenceViewpointCommand command = new ReferenceViewpointCommand(vpResource, set);
        this.executeCommand((Command)command);
    }

    private void executeCommand(Command command) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)this.target);
        if (editingDomain == null && this.target instanceof IEditingDomainProvider) {
            editingDomain = ((IEditingDomainProvider)this.target).getEditingDomain();
        }
        editingDomain.getCommandStack().execute(command);
    }

    protected void manageDependencies(ResourceSet set, Resource vpResource) throws ViewpointActivationException {
        URI uri = URIHelper.createURI((Resource)vpResource);
        Viewpoint vp = (Viewpoint)set.getEObject(uri, true);
        List<String> vpDependencies = this.dependencies.get(vpResource.getId());
        if (vpDependencies == null) {
            vpDependencies = new ArrayList<String>();
            this.dependencies.put(vpResource.getId(), vpDependencies);
        }
        vpDependencies.clear();
        ArrayList dependencies = new ArrayList(10);
        dependencies.addAll(vp.getDependencies());
        dependencies.addAll(vp.getParents());
        for (Viewpoint dep : dependencies) {
            String id = dep.getId();
            vpDependencies.add(id);
            if (this.isReferenced(id)) continue;
            this.doReference(set, ViewpointManager.getViewpoint(id));
        }
    }

    protected void startBundle(Resource vpResource) throws ViewpointActivationException {
        String providerSymbolicName = vpResource.getProviderSymbolicName();
        Bundle bundle = Platform.getBundle((String)providerSymbolicName);
        if (bundle == null || this.managed.contains(providerSymbolicName)) {
            this.activateBundle(providerSymbolicName);
            bundle = Platform.getBundle((String)providerSymbolicName);
        }
        if (bundle == null) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_7, (Object)providerSymbolicName));
        }
        try {
            bundle.start(1);
            Thread.sleep(100L);
        }
        catch (Exception e) {
            throw new ViewpointActivationException(e);
        }
    }

    protected void activateBundle(String id) throws ViewpointActivationException {
        if (Platform.getBundle((String)id) == null) {
            throw new ViewpointActivationException(Messages.Viewpoint_Manager_error_5);
        }
    }

    protected void desactivateBundle(String id) throws ViewpointActivationException {
    }

    public void desactivate(String id) throws ViewpointActivationException {
        this.stopUse(id);
    }

    public void stopUse(String id) throws ViewpointActivationException {
        this.unReference(id);
    }

    public void unReference(String id) throws ViewpointActivationException {
        Resource vpResource = ViewpointManager.getViewpoint(id);
        if (vpResource == null) {
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_3, (Object)id));
        }
        if (!this.isUsed(id)) {
            throw new AlreadyInStateException(NLS.bind((String)Messages.Viewpoint_Manager_error_6, (Object)id));
        }
        for (Map.Entry<String, List<String>> entry : this.dependencies.entrySet()) {
            if (!entry.getValue().contains(id)) continue;
            throw new ViewpointActivationException(NLS.bind((String)Messages.Viewpoint_Manager_error_8, (Object)id, (Object)entry.getKey()));
        }
        this.dependencies.remove(id);
        String providerSymbolicName = vpResource.getProviderSymbolicName();
        this.desactivateBundle(providerSymbolicName);
        MetadataHelper.getViewpointMetadata((ResourceSet)this.target).setUsage(vpResource, null, false);
        this.fireEvent(vpResource, 32);
    }

    public static void addOverallListener(OverallListener2 l) {
        if (overallListener2s.contains(l)) {
            return;
        }
        overallListener2s.add(l);
    }

    public static void removeOverallListener(OverallListener2 l) {
        overallListener2s.remove(l);
    }

    public static void addOverallListener(OverallListener l) {
        if (overallListeners.contains(l)) {
            return;
        }
        overallListeners.add(l);
    }

    public static void removeOverallListener(OverallListener l) {
        overallListeners.remove(l);
    }

    public void addListener(Listener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    public void addListener(Listener2 l) {
        if (this.listener2s.contains(l)) {
            return;
        }
        this.listener2s.add(l);
    }

    public void removeListener(Listener2 l) {
        this.listener2s.remove(l);
    }

    protected void fireEvent(Resource vpResource, int event) {
        Object l;
        Object[] objectArray = this.listeners.toArray(new Listener[this.listeners.size()]);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = objectArray[n2];
            try {
                switch (event) {
                    case 16: {
                        l.hasBeenActivated(vpResource);
                        break;
                    }
                    case 32: {
                        l.hasBeenDeactivated(vpResource);
                        break;
                    }
                    case 128: {
                        l.hasBeenFiltered(vpResource);
                        break;
                    }
                    case 64: {
                        l.hasBeenDisplayed(vpResource);
                    }
                }
            }
            catch (Exception e) {
                AD_Log.getDefault().logError(Messages.Viewpoint_Manager_error_9, (Throwable)e);
            }
            ++n2;
        }
        objectArray = this.listener2s.toArray(new Listener2[this.listener2s.size()]);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            l = objectArray[n2];
            try {
                switch (event) {
                    case 16: {
                        l.handleReferencing(vpResource);
                        break;
                    }
                    case 32: {
                        l.handleUnReferencing(vpResource);
                        break;
                    }
                    case 64: {
                        l.handleActivation(vpResource);
                        break;
                    }
                    case 128: {
                        l.handleInactivation(vpResource);
                    }
                }
            }
            catch (Exception e) {
                AD_Log.getDefault().logError(Messages.Viewpoint_Manager_error_9, (Throwable)e);
            }
            ++n2;
        }
        objectArray = overallListeners.toArray(new OverallListener[overallListeners.size()]);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            l = objectArray[n2];
            try {
                switch (event) {
                    case 16: {
                        l.hasBeenActivated(this.target, vpResource);
                        break;
                    }
                    case 32: {
                        l.hasBeenDeactivated(this.target, vpResource);
                        break;
                    }
                    case 128: {
                        l.hasBeenFiltered(this.target, vpResource);
                        break;
                    }
                    case 64: {
                        l.hasBeenDisplayed(this.target, vpResource);
                    }
                }
            }
            catch (Exception e) {
                AD_Log.getDefault().logError(Messages.Viewpoint_Manager_error_9, (Throwable)e);
            }
            ++n2;
        }
        objectArray = overallListener2s.toArray(new OverallListener2[overallListener2s.size()]);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            l = objectArray[n2];
            try {
                switch (event) {
                    case 16: {
                        l.handleReferencing(this.target, vpResource);
                        break;
                    }
                    case 32: {
                        l.handleUnReferencing(this.target, vpResource);
                        break;
                    }
                    case 64: {
                        l.handleActivation(this.target, vpResource);
                        break;
                    }
                    case 128: {
                        l.handleInactivation(this.target, vpResource);
                    }
                }
            }
            catch (Exception e) {
                AD_Log.getDefault().logError(Messages.Viewpoint_Manager_error_9, (Throwable)e);
            }
            ++n2;
        }
    }

    public static ViewpointManager getInstance(EObject ctx1) {
        if (ctx1 == null || ctx1.eResource() == null) {
            return nullManager;
        }
        ResourceSet ctx = ctx1.eResource().getResourceSet();
        return ViewpointManager.getInstance(ctx);
    }

    public static ViewpointManager getInstance(final ResourceSet ctx) {
        if (ctx == null) {
            return nullManager;
        }
        ViewpointManager instance = instances.get(ctx);
        if (instance == null) {
            instance = ViewpointManager.createInstance();
            instances.put(ctx, instance);
            ctx.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() == 4 && ctx.getResources().isEmpty()) {
                        instances.remove(ctx);
                    }
                }
            });
            instance.setTarget(ctx);
        }
        return instance;
    }

    private static ViewpointManager createInstance() {
        ViewpointManager instance = null;
        try {
            IConfigurationElement[] elts = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.ad.services.viewpoint.manager");
            instance = elts == null || elts.length == 0 ? new ViewpointManager() : (ViewpointManager)elts[0].createExecutableExtension("class");
        }
        catch (CoreException e) {
            AD_Log.getDefault().logError(Messages.Viewpoint_Manager_error_2, (Throwable)e);
            instance = new ViewpointManager();
        }
        return instance;
    }

    private static class CachingFinder
    extends ViewpointFinder {
        private Resource[] availableViewpoints;

        private CachingFinder() {
        }

        @Override
        public Resource[] getAvailableViewpoints() {
            if (this.availableViewpoints == null) {
                this.availableViewpoints = super.getAvailableViewpoints();
            }
            return this.availableViewpoints;
        }

        @Override
        protected void pinError(String id) {
            super.pinError(id);
            if (this.availableViewpoints != null) {
                Resource[] resourceArray = this.availableViewpoints;
                int n = this.availableViewpoints.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    if (id.equals(r.getId())) {
                        ArrayList<Resource> result = new ArrayList<Resource>();
                        result.addAll(Arrays.asList(this.availableViewpoints));
                        result.remove(r);
                        this.availableViewpoints = result.toArray(new Resource[result.size()]);
                        return;
                    }
                    ++n2;
                }
            }
        }
    }

    protected final class ChangeViewpointVisibilityCommand
    extends AbstractCommand {
        private boolean visible;
        private Resource vpResource;

        public ChangeViewpointVisibilityCommand(Resource vpResource, boolean visible) {
            super(visible ? "Show viewpoint" : "Hide viewpoint");
            this.vpResource = vpResource;
            this.visible = visible;
        }

        public void execute() {
            MetadataHelper.getViewpointMetadata((ResourceSet)ViewpointManager.this.target).setActivationSate(this.vpResource.getId(), this.visible);
            ViewpointManager.this.fireEvent(this.vpResource, this.visible ? 64 : 128);
        }

        public void undo() {
            MetadataHelper.getViewpointMetadata((ResourceSet)ViewpointManager.this.target).setActivationSate(this.vpResource.getId(), !this.visible);
            ViewpointManager.this.fireEvent(this.vpResource, !this.visible ? 64 : 128);
        }

        public void redo() {
            this.execute();
        }

        protected boolean prepare() {
            return true;
        }
    }

    public static class Description {
        private final String id;
        private final String label;
        private final Version version;
        private Resource resource;

        public Description(String id, String label, Version version, Resource resource) {
            this.id = id;
            this.label = label;
            this.version = version;
            this.resource = resource;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean shloudBeHidden() {
            return this.resource.getTags().contains(ViewpointManager.VIEWPOINT_STATE_HIDDEN);
        }
    }

    @Deprecated
    public static interface Listener {
        @Deprecated
        public void hasBeenActivated(Resource var1);

        @Deprecated
        public void hasBeenDeactivated(Resource var1);

        @Deprecated
        public void hasBeenFiltered(Resource var1);

        @Deprecated
        public void hasBeenDisplayed(Resource var1);
    }

    public static interface Listener2 {
        public void handleReferencing(Resource var1);

        public void handleUnReferencing(Resource var1);

        public void handleActivation(Resource var1);

        public void handleInactivation(Resource var1);
    }

    private static class NullViewpointManager
    extends ViewpointManager {
        @Override
        public void unReference(String id) throws ViewpointActivationException {
        }

        @Override
        public void reference(String id) throws ViewpointActivationException {
        }

        @Override
        public boolean hasMetadata() {
            return false;
        }

        @Override
        public void setActivationState(String id, boolean active) throws ViewpointActivationException {
        }

        @Override
        public boolean isInactive(String id) {
            return false;
        }

        @Override
        public boolean isReferenced(String id) {
            return false;
        }
    }

    @Deprecated
    public static interface OverallListener {
        @Deprecated
        public void hasBeenActivated(Object var1, Resource var2);

        @Deprecated
        public void hasBeenDeactivated(Object var1, Resource var2);

        @Deprecated
        public void hasBeenFiltered(Object var1, Resource var2);

        @Deprecated
        public void hasBeenDisplayed(Object var1, Resource var2);
    }

    public static interface OverallListener2 {
        public void handleReferencing(Object var1, Resource var2);

        public void handleUnReferencing(Object var1, Resource var2);

        public void handleActivation(Object var1, Resource var2);

        public void handleInactivation(Object var1, Resource var2);
    }

    protected final class ReferenceViewpointCommand
    extends AbstractCommand {
        private final Resource vpResource;
        private final ResourceSet set;

        public ReferenceViewpointCommand(Resource vpResource, ResourceSet set) {
            super("Reference viewpoint");
            this.vpResource = vpResource;
            this.set = set;
        }

        public void execute() {
            Version readVersion = ViewpointManager.readVersion(this.set, this.vpResource);
            MetadataHelper.getViewpointMetadata((ResourceSet)ViewpointManager.this.target).reference(this.vpResource, readVersion);
            if (Location.WORSPACE.equals((Object)this.vpResource.getProviderLocation())) {
                ViewpointManager.this.managed.add(this.vpResource.getProviderSymbolicName());
            }
            ViewpointManager.this.fireEvent(this.vpResource, 16);
        }

        public void undo() {
            MetadataHelper.getViewpointMetadata((ResourceSet)ViewpointManager.this.target).unReference(this.vpResource);
            ViewpointManager.this.fireEvent(this.vpResource, 32);
        }

        public void redo() {
            this.execute();
        }

        protected boolean prepare() {
            return true;
        }
    }

    public static abstract class ViewpointFinder {
        private final Set<String> discarded = new HashSet<String>();

        public Resource[] getAvailableViewpoints() {
            SearchCriteria searchCriteria = new SearchCriteria();
            searchCriteria.setDomain("AF");
            searchCriteria.getTags().add("vp");
            Resource[] resources = ResourceReuse.createHelper().getResources(searchCriteria);
            if (this.discarded.isEmpty()) {
                return resources;
            }
            ArrayList<Resource> result = new ArrayList<Resource>(resources.length);
            Resource[] resourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource res = resourceArray[n2];
                if (!this.discarded.contains(res.getId())) {
                    result.add(res);
                }
                ++n2;
            }
            return result.toArray(new Resource[result.size()]);
        }

        public void pinError(Resource vp, Exception e) {
            this.pinError(vp.getId());
            String msg = "Resource '" + vp.getId() + "' cannot be loaded, The viewpoint is discarded.";
            AD_Log.getDefault().logError(msg, (Throwable)e);
        }

        public void pinError(Resource vp, String details) {
            this.pinError(vp.getId());
            String msg = "Resource '" + vp.getId() + "' cannot be loaded, The viewpoint is discarded.\n" + details;
            AD_Log.getDefault().logError(msg);
        }

        protected void pinError(String id) {
            this.discarded.add(id);
        }
    }
}

