/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.properties;

import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationMessageInjector {
    private static final String VALIDATION_MESSAGE_KEY = "org.eclipse.emf.eef.runtime.part.impl.util.ValidationMessageInjector";
    private TabbedPropertySheetPage page;
    private TabbedPropertyComposite propertyComposite;
    private TabbedPropertyTitle propertyTitle;
    private CLabel propertyTitleLabel;

    public ValidationMessageInjector(TabbedPropertySheetPage page) {
        this.page = page;
        this.initialize();
    }

    public void setMessage(String message, int severity) {
        if (this.isValide()) {
            if (severity == 4) {
                CLabel messageControl = this.getMessage();
                messageControl.setText("Errors");
                messageControl.setForeground(this.propertyComposite.getDisplay().getSystemColor(3));
                messageControl.setImage(EEFRuntimePlugin.getImage((String)"icons/16x16/ValidationErrors.gif"));
                messageControl.setToolTipText(message);
            } else if (severity == 2) {
                CLabel messageControl = this.getMessage();
                messageControl.setText("Warnings");
                messageControl.setForeground(this.propertyComposite.getDisplay().getSystemColor(8));
                messageControl.setImage(EEFRuntimePlugin.getImage((String)"icons/16x16/ValidationWarnings.gif"));
                messageControl.setToolTipText(message);
            } else {
                this.dispose();
            }
        }
    }

    public final void dispose() {
        if (this.isValide()) {
            FormData data;
            CLabel message = this.getMessage();
            if (message != null && !message.isDisposed()) {
                data = (FormData)message.getLayoutData();
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(0, 0);
                data.top = new FormAttachment(0, 0);
                data.bottom = new FormAttachment(0, 0);
                message.setVisible(false);
                this.propertyTitle.layout();
                message.dispose();
            }
            if (this.propertyTitleLabel.getLayoutData() instanceof FormData) {
                data = (FormData)this.propertyTitleLabel.getLayoutData();
                data.right = new FormAttachment(100, 0);
            }
            this.propertyTitle.layout();
            this.propertyComposite.setData(VALIDATION_MESSAGE_KEY, null);
        }
    }

    public final boolean isValide() {
        return this.propertyComposite != null && !this.propertyComposite.isDisposed() && this.propertyTitleLabel != null;
    }

    private void initialize() {
        if (this.page.getControl() instanceof TabbedPropertyComposite) {
            this.propertyComposite = (TabbedPropertyComposite)this.page.getControl();
            this.propertyTitle = this.searchTitle((Composite)this.propertyComposite);
            if (this.propertyTitle != null) {
                this.propertyTitleLabel = this.searchLabel(this.propertyTitle);
            }
        }
    }

    private CLabel getMessage() {
        if (this.propertyComposite.getData(VALIDATION_MESSAGE_KEY) != null && !((CLabel)this.propertyComposite.getData(VALIDATION_MESSAGE_KEY)).isDisposed()) {
            return (CLabel)this.propertyComposite.getData(VALIDATION_MESSAGE_KEY);
        }
        CLabel message = this.instanciateMessageAt(this.propertyTitle, this.propertyTitleLabel);
        this.relayoutTitleLabel(this.propertyTitleLabel);
        this.propertyTitle.layout();
        this.propertyComposite.layout();
        this.propertyComposite.setData(VALIDATION_MESSAGE_KEY, (Object)message);
        return message;
    }

    private TabbedPropertyTitle searchTitle(Composite composite) {
        return (TabbedPropertyTitle)this.searchComposite(composite, TabbedPropertyTitle.class);
    }

    private CLabel searchLabel(TabbedPropertyTitle title) {
        return (CLabel)this.searchComposite((Composite)title, CLabel.class);
    }

    private Composite searchComposite(Composite composite, Class<? extends Composite> clazz) {
        int i = 0;
        while (i < composite.getChildren().length) {
            Composite searchedComposite;
            Control control = composite.getChildren()[i];
            if (clazz.isInstance(control)) {
                return (Composite)control;
            }
            if (control instanceof Composite && (searchedComposite = this.searchComposite((Composite)control, clazz)) != null) {
                return searchedComposite;
            }
            ++i;
        }
        return null;
    }

    private CLabel instanciateMessageAt(TabbedPropertyTitle title, CLabel titleLabel) {
        TabbedPropertySheetWidgetFactory factory = this.page.getWidgetFactory();
        CLabel result = factory.createCLabel((Composite)title, "default");
        result.setBackground(new Color[]{factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END"), factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START")}, new int[]{100}, true);
        FormData errordata = new FormData();
        errordata.left = new FormAttachment(90, 5);
        errordata.top = new FormAttachment(0, 0);
        errordata.right = new FormAttachment(100, 5);
        errordata.bottom = new FormAttachment(100, 0);
        result.setLayoutData((Object)errordata);
        return result;
    }

    private boolean relayoutTitleLabel(CLabel label) {
        if (label.getLayoutData() instanceof FormData) {
            FormData data = (FormData)label.getLayoutData();
            data.right = new FormAttachment(90, -5);
            return true;
        }
        return false;
    }
}

