/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.composer.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NsURIAnalyzer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern PATTERN = Pattern.compile("(xmlns:.*?=\"(.*?)\")");

    public static Collection<String> getNsURIs(File file) {
        HashSet<String> result = new HashSet<String>();
        StringBuilder content = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                    content.append(LINE_SEPARATOR);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.polarsys.kitalpha.composer.core", "Impossible to read file: " + file.getName(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        Matcher matcher = PATTERN.matcher(content);
        while (matcher.find()) {
            if (matcher.groupCount() < 2) continue;
            result.add(matcher.group(2));
        }
        return result;
    }
}

