/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.internal.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.polarsys.kitalpha.cadence.core.api.CadenceRegistry;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.composer.Activator;
import org.polarsys.kitalpha.composer.api.CodeManagerCadenceLaunchConfiguration;
import org.polarsys.kitalpha.composer.api.CodeManagerLauncher;
import org.polarsys.kitalpha.composer.api.CodeManagerRegistry;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.api.library.LibraryReuseHelper;
import org.polarsys.kitalpha.composer.api.path.ComposerPathUtils;
import org.polarsys.kitalpha.composer.extension.points.IGenerator;
import org.polarsys.kitalpha.composer.extension.points.IRefinery;
import org.polarsys.kitalpha.composer.extension.points.IStrategy;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeManagerApplication
implements IApplication {
    IProject project;

    public Object start(IApplicationContext context) throws Exception {
        File model_f;
        String gen_path;
        File file;
        Path location;
        IFolder gen_f;
        System.out.print("Launching Composer in standalone mode");
        String[] args = (String[])context.getArguments().get("application.args");
        String model_path = args[0];
        String composer_property_path = args[1];
        System.out.println("Reading properties file");
        Properties properties = new Properties();
        properties.load(new FileInputStream(composer_property_path));
        String gen_path0 = properties.getProperty("generator.path");
        System.out.println("Creation tempory project");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject("External Files");
        if (!this.project.exists()) {
            this.project.create(null);
        }
        if (!this.project.isOpen()) {
            this.project.open(null);
        }
        if (!(gen_f = this.project.getFolder((location = new Path((file = new File(gen_path = ComposerPathUtils.pathVariablesDecode(gen_path0, model_f = new File(model_path)))).getPath())).lastSegment())).exists()) {
            if (!file.exists()) {
                file.mkdirs();
            }
            gen_f.createLink(file.toURI(), 0, null);
        }
        IStatus status = this.createLaunchConfig(properties, model_f, gen_f);
        this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        return status.isOK() ? IApplication.EXIT_OK : IApplicationContext.EXIT_ASYNC_RESULT;
    }

    private IStatus createLaunchConfig(Properties properties_p, File model_file_p, IFolder gen_folder_p) throws Exception {
        System.out.println("Building the composer launch configuration");
        String strategyId = properties_p.getProperty("strategyId");
        System.out.println("The strategy is : " + strategyId);
        IStrategy strategy = CodeManagerRegistry.getStrategyFromId(strategyId);
        System.out.println("Retrieve parameters of the strategy");
        Map<String, Parameter> strategyParams = strategy.getParameters();
        if (strategyParams != null && !strategyParams.isEmpty()) {
            strategyParams = this.setParameters(properties_p, strategyParams, "strategy");
        }
        String refineryId = properties_p.getProperty("refineryId");
        System.out.println("The refinery is : " + refineryId);
        IRefinery refinery = CodeManagerRegistry.getRefineryFromId(refineryId);
        System.out.println("Retrieve parameters of the refinry");
        Map<String, Parameter> refineryParams = refinery.getParameters();
        if (refineryParams != null && !refineryParams.isEmpty()) {
            refineryParams = this.setParameters(properties_p, refineryParams, "refinery");
        }
        String generatorId = properties_p.getProperty("generatorId");
        System.out.println("The generator is : " + generatorId);
        IGenerator generator = CodeManagerRegistry.getGeneratorFromId(generatorId);
        Map<String, Parameter> generatorParams = generator.getParameters();
        System.out.println("Retrieve parameters of the generator");
        if (generatorParams != null && !generatorParams.isEmpty()) {
            generatorParams = this.setParameters(properties_p, generatorParams, "generator");
        }
        String missingLib = properties_p.getProperty("missingLib.path");
        System.out.println("Retrieve libraries used");
        String libraries = properties_p.getProperty("librariesId");
        List<Resource> selectedLibs = this.getLibraries(libraries);
        org.eclipse.emf.ecore.resource.Resource resource = this.getModelResource(model_file_p);
        CodeManagerCadenceLaunchConfiguration cadenceConfig = this.setCadenceConfiguration(properties_p);
        System.out.println("end of the construction of the Composer launch configuration");
        System.out.println("Execution of the generation plan");
        IStatus status = CodeManagerLauncher.launch(strategy, strategyParams, refinery, refineryParams, generator, gen_folder_p.getFullPath(), generatorParams, selectedLibs, missingLib, resource, cadenceConfig, false);
        System.out.println("End of the execution of the generation plan");
        System.out.println("-----------");
        System.out.println("- results -");
        System.out.println("-----------");
        if (status.isOK()) {
            System.out.println("SUCCESS");
        } else {
            System.err.println("ERROR");
            System.err.println("Severity : " + status.getSeverity());
            System.err.println("Reason : " + status.getMessage());
        }
        return status;
    }

    private CodeManagerCadenceLaunchConfiguration setCadenceConfiguration(Properties properties_p) {
        CodeManagerCadenceLaunchConfiguration cadenceConfig = new CodeManagerCadenceLaunchConfiguration();
        WorkflowActivityParameter beforeStrategy = this.getWorkFlowParameter(properties_p, "org.polarsys.kitalpha.composer.core.workflow.beforestrategy", "cadence.before.strategy");
        cadenceConfig.setBeforeStrategyActivities(beforeStrategy);
        WorkflowActivityParameter beforeRefinery = this.getWorkFlowParameter(properties_p, "org.polarsys.kitalpha.composer.core.workflow.beforerefinery", "cadence.before.refinery");
        cadenceConfig.setBeforeRefineryActivities(beforeRefinery);
        WorkflowActivityParameter beforeGenerator = this.getWorkFlowParameter(properties_p, "org.polarsys.kitalpha.composer.core.workflow.beforegeneration", "cadence.before.generator");
        cadenceConfig.setBeforeGenerationActivities(beforeGenerator);
        WorkflowActivityParameter afterGenerator = this.getWorkFlowParameter(properties_p, "org.polarsys.kitalpha.composer.core.workflow.aftergeneration", "cadence.after.generator");
        cadenceConfig.setAfterGenerationActivities(afterGenerator);
        return cadenceConfig;
    }

    private WorkflowActivityParameter getWorkFlowParameter(Properties properties_p, String cadence_workflow_element_id, String name) {
        String activitiesIds = properties_p.getProperty(name);
        WorkflowActivityParameter wkparameter = new WorkflowActivityParameter();
        if (activitiesIds != null && !activitiesIds.equals("")) {
            String[] activitiesTabIds;
            String[] stringArray = activitiesTabIds = activitiesIds.split(Pattern.quote(","));
            int n = activitiesTabIds.length;
            int n2 = 0;
            while (n2 < n) {
                String activityId = stringArray[n2];
                wkparameter.addActivity(activityId);
                IActivity activity = CadenceRegistry.getIActivityClassFromId((String)activityId);
                if (activity != null) {
                    wkparameter = this.setParameters(properties_p, activityId, activity.getParameters(), wkparameter, String.valueOf(name) + "." + activityId);
                }
                ++n2;
            }
        }
        return wkparameter;
    }

    private WorkflowActivityParameter setParameters(Properties properties_p, String activityId, Collection<DeclaredParameter> parameters_p, WorkflowActivityParameter workflowParameter, String key_prefix_p) {
        if (parameters_p != null) {
            for (DeclaredParameter parameter : parameters_p) {
                String file_key = String.valueOf(key_prefix_p) + "." + parameter.getName();
                String value = properties_p.getProperty(file_key);
                parameter.setValue((Object)value);
                workflowParameter.addParameter(activityId, (GenericParameter)parameter);
            }
        }
        return workflowParameter;
    }

    private org.eclipse.emf.ecore.resource.Resource getModelResource(File file_p) {
        org.eclipse.emf.ecore.resource.Resource resource = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resource = resourceSet.getResource(URI.createFileURI((String)file_p.getPath()), true);
        return resource;
    }

    private Map<String, Parameter> setParameters(Properties properties_p, Map<String, Parameter> params_p, String key_prefix_p) {
        for (String key : params_p.keySet()) {
            String file_key = String.valueOf(key_prefix_p) + "." + key;
            String value = properties_p.getProperty(file_key);
            Parameter p = params_p.get(key);
            if (value == null) continue;
            p.setValue(value);
        }
        return params_p;
    }

    public void stop() {
        try {
            this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.composer.core", e.getMessage()));
        }
    }

    private List<Resource> getLibraries(String libraries) {
        List<Resource> result = new ArrayList<Resource>();
        if (libraries != null && !libraries.equals("")) {
            String[] tab = libraries.split(";");
            result = LibraryReuseHelper.INSTANCE.getResourcesFromIds(Arrays.asList(tab));
        }
        return result;
    }
}

