/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleURLConverter {
    private static final String FILE_PROTOCOL = "file:";
    private static final List<String> IGNORED_URI_SEGMENTS = new ArrayList<String>(3);
    private static final String JAR_PROTOCOL = "jar:";
    private static final String PLATFORM_PLUGIN_PROTOCOL = "platform:/plugin";
    private final String baseURL;
    private Bundle bundle;
    private String bundlePath;
    private String nativeProtocolURL;

    static {
        IGNORED_URI_SEGMENTS.add("@dot");
        IGNORED_URI_SEGMENTS.add("bin");
        IGNORED_URI_SEGMENTS.add("src");
    }

    public BundleURLConverter(String base) {
        this.baseURL = base;
    }

    private static boolean isBundleIDCandidate(String s) {
        if (s.length() == 0 || s.length() > 5) {
            return false;
        }
        boolean isInteger = true;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                isInteger = false;
            }
            ++n2;
        }
        return isInteger;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String resolveAsNativeProtocolURL() {
        if (this.nativeProtocolURL == null) {
            this.resolveBundle();
        }
        return this.nativeProtocolURL;
    }

    public String resolveAsPlatformPlugin() {
        Bundle containingBundle = this.resolveBundle();
        String relativePath = this.bundlePath;
        if (this.bundlePath == null || containingBundle == null) {
            return null;
        }
        return "platform:/plugin/" + containingBundle.getSymbolicName() + relativePath;
    }

    public Bundle resolveInBundle(String qualifiedName) {
        if (this.bundle != null) {
            return this.bundle;
        }
        String actualPath = this.baseURL;
        if (actualPath.startsWith(JAR_PROTOCOL)) {
            actualPath = this.trimJarAffixAndQualifier(actualPath);
        }
        if (actualPath.startsWith("file:/")) {
            actualPath = actualPath.substring(FILE_PROTOCOL.length() + 1);
        }
        if (actualPath.contains("#")) {
            actualPath = actualPath.substring(0, actualPath.indexOf(35));
        }
        Bundle tempBundle = null;
        String tempPath = null;
        String tempWithIgnoredSegments = null;
        String[] segments = actualPath.split("/|\\\\");
        int i = segments.length - 1;
        while (i >= 0 && this.bundle == null) {
            tempBundle = BundleURLConverter.isBundleIDCandidate(segments[i]) ? AcceleoCommonPlugin.getDefault().getContext().getBundle(Long.valueOf(segments[i]).longValue()) : Platform.getBundle((String)segments[i]);
            if (tempBundle != null && qualifiedName == null) {
                tempPath = "";
                int pathStart = i + 1;
                if ((pathStart >= segments.length || !".cp".equals(segments[pathStart])) && segments.length > pathStart + 1 && ".cp".equals(segments[pathStart + 1])) {
                    pathStart += 2;
                }
                boolean containsIgnoredSegments = false;
                int j = ++pathStart;
                while (j < segments.length) {
                    if (containsIgnoredSegments) {
                        tempWithIgnoredSegments = String.valueOf(tempWithIgnoredSegments) + '/' + segments[j];
                    }
                    if (!IGNORED_URI_SEGMENTS.contains(segments[j])) {
                        tempPath = String.valueOf(tempPath) + '/' + segments[j];
                    } else if (!containsIgnoredSegments) {
                        containsIgnoredSegments = true;
                        tempWithIgnoredSegments = String.valueOf('/') + segments[j];
                    }
                    ++j;
                }
                URL fileURL = tempBundle.getEntry(tempPath);
                if (fileURL != null) {
                    this.bundle = tempBundle;
                    this.bundlePath = tempPath;
                } else if (tempWithIgnoredSegments != null && (fileURL = tempBundle.getEntry(tempWithIgnoredSegments)) != null) {
                    this.bundle = tempBundle;
                    this.bundlePath = tempWithIgnoredSegments;
                }
                if (fileURL != null) {
                    try {
                        this.nativeProtocolURL = FileLocator.resolve((URL)fileURL).toString();
                    }
                    catch (IOException e) {
                        AcceleoCommonPlugin.log(e, true);
                    }
                }
            } else if (tempBundle != null) {
                try {
                    tempBundle.loadClass(qualifiedName);
                    this.bundle = tempBundle;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            --i;
        }
        return this.bundle;
    }

    public Bundle resolveBundle() {
        return this.resolveInBundle(null);
    }

    private String trimJarAffixAndQualifier(String path) {
        String actualPath = path.substring(JAR_PROTOCOL.length());
        actualPath = actualPath.contains("_") ? actualPath.replaceFirst("(?:/|\\\\)([^/]*?)_[^_]*\\.jar!/", "/$1/") : actualPath.replaceFirst("\\.jar!", "");
        return actualPath;
    }
}

