/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDataConfigContainer<T> {
    private Map<String, Map<T, T>> configMaps = new HashMap<String, Map<T, T>>();
    private Map<String, List<T>> configLists = new HashMap<String, List<T>>();
    private boolean canManageSourceFolders = false;
    private boolean canManageCronTriggers = false;
    private boolean canManageSCMTriggers = false;
    private boolean canManageUsers = false;
    private boolean canManageHudsonProperties = false;
    private boolean canManageGenerationLocation = false;

    public void addMap(String id, Map<T, T> newMap) {
        if (newMap != null && !newMap.isEmpty() && id != null && this.configMaps != null) {
            this.configMaps.put(id, newMap);
            if (id.equals("build.users")) {
                this.canManageUsers = true;
            }
            if (id.equals("hudson.properties")) {
                this.canManageHudsonProperties = true;
            }
            if (id.equals("generation.location")) {
                this.canManageGenerationLocation = true;
            }
        }
    }

    public Map<T, T> getMap(String id) {
        if (id != null) {
            if (id.equals("build.users") && this.canManageUsers) {
                return this.configMaps.get(id);
            }
            if (id.equals("hudson.properties") && this.canManageHudsonProperties) {
                return this.configMaps.get(id);
            }
            if (id.equals("generation.location") && this.canManageGenerationLocation) {
                return this.configMaps.get(id);
            }
        }
        return null;
    }

    public void addList(String id, List<T> newList) {
        if (newList != null && !newList.isEmpty() && id != null && this.configLists != null) {
            this.configLists.put(id, newList);
            if (id.equals("source.folders")) {
                this.canManageSourceFolders = true;
            }
            if (id.equals("cron.triggers")) {
                this.canManageCronTriggers = true;
            }
            if (id.equals("scm.triggers")) {
                this.canManageSCMTriggers = true;
            }
        }
    }

    public List<T> getList(String id) {
        if (id != null) {
            if (id.equals("source.folders") && this.canManageSourceFolders) {
                return this.configLists.get(id);
            }
            if (id.equals("cron.triggers") && this.canManageCronTriggers) {
                return this.configLists.get(id);
            }
            if (id.equals("scm.triggers") && this.canManageSCMTriggers) {
                return this.configLists.get(id);
            }
        }
        return null;
    }

    public Map<String, Map<T, T>> getConfigMaps() {
        return this.configMaps;
    }

    public void setConfigMaps(Map<String, Map<T, T>> configMaps) {
        this.configMaps = configMaps;
    }

    public Map<String, List<T>> getConfigLists() {
        return this.configLists;
    }

    public void setConfigLists(Map<String, List<T>> configLists) {
        this.configLists = configLists;
    }

    public boolean iscanManageSourceFolders() {
        return this.canManageSourceFolders;
    }

    public boolean iscanManageCronTriggers() {
        return this.canManageCronTriggers;
    }

    public boolean iscanManageSCMTriggers() {
        return this.canManageSCMTriggers;
    }

    public boolean iscanManageUsers() {
        return this.canManageUsers;
    }

    public boolean iscanManageHudsonProperties() {
        return this.canManageHudsonProperties;
    }

    public boolean iscanManageGenerationLocation() {
        return this.canManageGenerationLocation;
    }
}

