/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.processing;

import java.io.IOException;
import java.net.ConnectException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.mwe.core.debug.processing.ElementAdapter;
import org.eclipse.emf.mwe.core.debug.processing.EventHandler;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.processing.CommandListener;
import org.eclipse.emf.mwe.internal.core.debug.processing.DebuggerInterruptedException;
import org.eclipse.emf.mwe.internal.core.debug.processing.ProcessHandler;
import org.eclipse.emf.mwe.internal.core.debug.processing.RuntimeHandlerManager;

public class DebugMonitor
implements ProgressMonitor {
    private static final int STARTED = 1;
    private static final int PRE_TASK = 2;
    private static final int POST_TASK = 3;
    private static final int SUSPENDED = 4;
    private static final int RESUMED = 5;
    private static final int TERMINATED = 6;
    private final Connection connection = new Connection();
    private CommandListener commandListener;
    private final Set<ProcessHandler> processHandlers = new HashSet<ProcessHandler>();
    private final Set<EventHandler> eventHandlers = new HashSet<EventHandler>();
    private final Set<ElementAdapter> elementAdapters = new HashSet<ElementAdapter>();
    private boolean missingAdapterReported;
    private Object context;

    public void init(String[] args) throws IOException {
        int port = this.findPort(args);
        this.init(port);
    }

    public void init(int port) throws IOException {
        try {
            this.connection.connect(port);
        }
        catch (ConnectException e) {
            throw new IOException("Couldn't establish connection to Debugger on port " + port);
        }
        try {
            RuntimeHandlerManager handler = new RuntimeHandlerManager(this);
            handler.setConnection(this.connection);
            handler.startListener();
        }
        catch (Exception e) {
            this.connection.close();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (IOException)e;
        }
    }

    private int findPort(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.startsWith("port=")) {
                return Integer.parseInt(string.substring(5));
            }
            ++n2;
        }
        return 0;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public void addProcessHandler(ProcessHandler handler) {
        this.processHandlers.add(handler);
    }

    public void addEventHandler(EventHandler handler) {
        this.eventHandlers.add(handler);
    }

    public void addAdapter(ElementAdapter adapter) {
        this.elementAdapters.add(adapter);
    }

    public ElementAdapter getAdapter(Object element) {
        for (ElementAdapter adapter : this.elementAdapters) {
            if (!adapter.canHandle(element)) continue;
            return adapter;
        }
        if (!this.missingAdapterReported) {
            System.out.println("Warning: Element can't be debugged.\nDidn't find an adapter for element of type " + element.getClass().getSimpleName());
            this.missingAdapterReported = true;
        }
        return null;
    }

    public void started(Object element, Object context) {
        this.fireEvent(1);
    }

    public void preTask(Object element, Object context) {
        this.context = context;
        ElementAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return;
        }
        adapter.setContext(context);
        if (!this.ask(1, element, 1)) {
            return;
        }
        this.fireEvent(2, element, 1);
        this.checkInterrupt();
        try {
            if (this.ask(3, element, 1)) {
                this.fireEvent(4);
                this.commandListener.listenCommand();
                this.checkInterrupt();
                this.fireEvent(5);
            }
        }
        catch (IOException e) {
            throw new DebuggerInterruptedException("User interrupt");
        }
    }

    public void postTask(Object element, Object context) {
        this.context = context;
        ElementAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return;
        }
        adapter.setContext(context);
        if (!this.ask(1, element, 2)) {
            return;
        }
        try {
            if (adapter.isSurroundingElement(element) && this.ask(3, element, 2)) {
                this.fireEvent(2, element, 2);
                this.fireEvent(4);
                this.commandListener.listenCommand();
                this.fireEvent(5);
                this.fireEvent(3);
            }
            this.fireEvent(3);
        }
        catch (IOException e) {
            throw new DebuggerInterruptedException(e);
        }
    }

    public void finished(Object element, Object context) {
        this.getAdapter(element).setContext(context);
        this.fireEvent(2, element, 2);
        this.fireEvent(4);
        this.fireEvent(3);
        this.fireEvent(6);
    }

    private void checkInterrupt() {
        if (this.ask(2, null, 0)) {
            throw new DebuggerInterruptedException("User interrupt");
        }
    }

    private void fireEvent(int event) {
        this.fireEvent(event, null, 0);
    }

    private void fireEvent(int event, Object element, int state) {
        for (EventHandler handler : this.eventHandlers) {
            try {
                if (event == 2) {
                    handler.preTask(element, this.context, state);
                    continue;
                }
                if (event == 3) {
                    handler.postTask(this.context);
                    continue;
                }
                if (event == 1) {
                    handler.started();
                    continue;
                }
                if (event == 4) {
                    handler.suspended();
                    continue;
                }
                if (event == 5) {
                    handler.resumed();
                    continue;
                }
                if (event != 6) continue;
                handler.terminated();
            }
            catch (IOException e) {
                throw new DebuggerInterruptedException(e);
            }
        }
    }

    private boolean ask(int event, Object element, int state) {
        boolean result = false;
        ProcessHandler lastHandler = null;
        for (ProcessHandler handler : this.processHandlers) {
            if (handler.isLastCall()) {
                lastHandler = handler;
                continue;
            }
            result = this.ask(event, element, state, result, handler);
        }
        if (lastHandler != null) {
            result = this.ask(event, element, state, result, lastHandler);
        }
        return result;
    }

    private boolean ask(int event, Object element, int state, boolean lastState, ProcessHandler handler) {
        boolean result = lastState;
        if (event == 1) {
            result = handler.shallHandle(result, element, state);
        } else if (event == 3) {
            result = handler.shallSuspend(result, element, state);
        } else if (event == 2) {
            result = handler.shallInterrupt(result);
        }
        return result;
    }

    public void beginTask(String name, int totalWork) {
    }

    public void done() {
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
    }

    public void clearBlocked() {
    }

    public void setBlocked(Diagnostic reason) {
    }
}

