/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceProvider;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.impl.EOperationService;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static Set<IService> getServices(IReadOnlyQueryEnvironment queryEnvironment, Class<?> cls) {
        LinkedHashSet<IService> result = new LinkedHashSet<IService>();
        Object instance = null;
        try {
            Constructor<?> cstr = null;
            cstr = cls.getConstructor(new Class[0]);
            instance = cstr.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        result.addAll(ServiceUtils.getServicesFromInstance(queryEnvironment, cls, instance));
        return result;
    }

    public static Set<IService> getServices(IReadOnlyQueryEnvironment queryEnvironment, Object instance) {
        return ServiceUtils.getServicesFromInstance(queryEnvironment, instance.getClass(), instance);
    }

    private static Set<IService> getServicesFromInstance(IReadOnlyQueryEnvironment queryEnvironment, Class<?> cls, Object instance) {
        LinkedHashSet<IService> result = new LinkedHashSet<IService>();
        if (instance instanceof IServiceProvider) {
            result.addAll(((IServiceProvider)instance).getServices(queryEnvironment));
        } else {
            Method[] methods;
            Method[] methodArray = methods = cls.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (ServiceUtils.isServiceMethod(instance, method)) {
                    JavaMethodService service = new JavaMethodService(method, instance);
                    result.add(service);
                }
                ++n2;
            }
        }
        return result;
    }

    public static boolean isServiceMethod(Object instance, Method method) {
        boolean result = method.getDeclaringClass() == Object.class ? false : (instance != null || Modifier.isStatic(method.getModifiers()) ? method.getParameterTypes().length > 0 : false);
        return result;
    }

    public static ServiceRegistrationResult registerServices(IQueryEnvironment queryEnvironment, Set<IService> services) {
        ServiceRegistrationResult result = new ServiceRegistrationResult();
        for (IService service : services) {
            result.merge(queryEnvironment.registerService(service));
        }
        return result;
    }

    public static void removeServices(IQueryEnvironment queryEnvironment, Set<IService> services) {
        for (IService service : services) {
            queryEnvironment.removeService(service);
        }
    }

    public static Set<IService> getServices(EPackage ePkg) {
        LinkedHashSet<IService> result = new LinkedHashSet<IService>();
        for (EClassifier eClassifier : ePkg.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            result.addAll(ServiceUtils.getServices((EClass)eClassifier));
        }
        for (EPackage child : ePkg.getESubpackages()) {
            result.addAll(ServiceUtils.getServices(child));
        }
        return result;
    }

    public static Set<IService> getServices(EClass eCls) {
        LinkedHashSet<IService> result = new LinkedHashSet<IService>();
        for (EOperation eOperation : eCls.getEAllOperations()) {
            result.add(new EOperationService(eOperation));
        }
        return result;
    }
}

