/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.common.utils.URIHelper;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusRepresentation;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;
import org.polarsys.kitalpha.ad.metadata.metadata.ViewpointReference;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RepresentationElement;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.modelresources.scrutinize.ModelResourcesScrutinizer;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes.ViewpointRelationshipHelper;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes.ViewpointTreeBuilder;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.helpers.FinderAFViewpointHelper;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.helpers.ViewpointsSearcherHelper;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class UsedAFViewpoints
implements IScrutinize<ViewpointTreeContainer, Object> {
    private Set<String> usedNsURI = new HashSet<String>();
    private Set<String> usedViewpoints = new HashSet<String>();
    private ViewpointTreeContainer container;

    public void findIn(EObject eObject) {
        String ePackageURI = FinderAFViewpointHelper.getEPackageNsURI_of((EObject)eObject);
        if (!this.usedNsURI.contains(ePackageURI)) {
            this.usedNsURI.add(ePackageURI);
        }
    }

    public void findIn(org.eclipse.emf.ecore.resource.Resource resource) {
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Metadata) {
            Metadata root = (Metadata)resource.getContents().get(0);
            for (ViewpointReference uv : root.getViewpointReferences()) {
                this.usedViewpoints.add(uv.getVpId());
            }
        }
    }

    public ViewpointTreeContainer getAnalysisResult() {
        if (this.container != null) {
            return this.container;
        }
        this.computeUsedViewpointsHierarchy();
        return this.container;
    }

    private void computeUsedViewpointsHierarchy() {
        Resource[] allVpResources = ViewpointsSearcherHelper.getAllViewpoints();
        Map<String, Collection<String>> viewpointsURIDependencies = ViewpointRelationshipHelper.getUsedRelationship(allVpResources);
        this.usedNsURI = FinderAFViewpointHelper.filterURISet(this.usedNsURI, viewpointsURIDependencies);
        Map filtredVpDependencies = FinderAFViewpointHelper.filterURIMap(viewpointsURIDependencies, this.usedNsURI);
        ViewpointTreeBuilder vpTreeBuilder = new ViewpointTreeBuilder();
        this.container = vpTreeBuilder.getViewpointTreeContainer(filtredVpDependencies, this.usedViewpoints);
    }

    public Object getFeedbackAnalysisMessages() {
        return null;
    }

    public void dispose() {
        this.container.dispose();
        this.container = null;
    }

    public Collection<String> getUsedNsURIs() {
        return new ArrayList<String>(this.usedNsURI);
    }

    @Deprecated
    public static Set<Resource> lookUp(org.eclipse.emf.ecore.resource.Resource resource) {
        return UsedAFViewpoints.lookUp(Collections.singleton(resource));
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Resource> lookUp(Collection<org.eclipse.emf.ecore.resource.Resource> resources) {
        result = new HashSet<Resource>();
        Scrutineer.startScrutiny(resources);
        nsUris = new HashSet<String>();
        odesigns = new HashSet<String>();
        UsedAFViewpoints.collectData(nsUris, odesigns);
        set = new ResourceSetImpl();
        try {
            var8_5 = ViewpointManager.getAvailableViewpoints();
            var7_6 = var8_5.length;
            var6_7 = 0;
            while (var6_7 < var7_6) {
                res = var8_5[var6_7];
                try {
                    uri = URIHelper.createURI((Resource)res);
                    vp = (Viewpoint)set.getEObject(uri, true);
                    if (vp.getMetamodel() != null) {
                        for (EPackage pack : vp.getMetamodel().getModels()) {
                            if (pack.getNsURI() == null || !nsUris.contains(pack.getNsURI())) continue;
                            result.add(res);
                        }
                    }
                    if (vp.getRepresentation() != null) {
                        for (RepresentationElement representation : vp.getRepresentation().getRepresentations()) {
                            if (!(representation instanceof SiriusRepresentation) || !odesigns.contains((uri2 = EcoreUtil.getURI((EObject)(sr = (SiriusRepresentation)representation).getOdesign())).lastSegment())) continue;
                            result.add(res);
                        }
                    }
                }
                catch (Exception e) {
                    ViewpointManager.pinError((Resource)res, (Exception)e);
                }
                ++var6_7;
            }
        }
        finally {
            ** for (r : set.getResources())
        }
lbl-1000:
        // 1 sources

        {
            r.unload();
            continue;
        }
lbl38:
        // 1 sources

        set.getResources().clear();
        return result;
    }

    private static void collectData(Set<String> nsUris, Set<String> odesigns) {
        try {
            ModelScrutinyRegistry.RegistryElement element = Scrutineer.getRegistryElement((String)"org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownresources.scrutiny");
            for (IScrutinize iFinder : element.getFinders()) {
                if (!(iFinder instanceof ModelResourcesScrutinizer)) continue;
                ModelResourcesScrutinizer resources = (ModelResourcesScrutinizer)iFinder;
                for (URI uri : resources.getAnalysisResult().getAllModelResourceURI()) {
                    if (!"odesign".equals(uri.fileExtension())) continue;
                    odesigns.add(uri.lastSegment());
                }
            }
            ModelScrutinyRegistry.RegistryElement vpElement = Scrutineer.getRegistryElement((String)"org.polarsys.kitalpha.model.common.scrutiny.contrib.scrutiny.viewpoints");
            for (IScrutinize iFinder : vpElement.getFinders()) {
                if (!(iFinder instanceof UsedAFViewpoints)) continue;
                UsedAFViewpoints afFinder = (UsedAFViewpoints)iFinder;
                nsUris.addAll(afFinder.getUsedNsURIs());
            }
        }
        catch (ModelScrutinyException e) {
            AD_Log.getDefault().logWarning((Throwable)e);
        }
    }
}

