/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.AbstractAssociation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Attribute;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Data;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Enumeration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.ExternalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.LocalAttributeType;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.CommonTemplateProposalProvider;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.output.TreeAppendable;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint;

public class VpuiTemplateProposalProvider
extends CommonTemplateProposalProvider {
    private ResourceSet resourceSet;
    @Inject
    private IValueConverterService valueConverter;

    @Inject
    public VpuiTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
        this.templateStore = templateStore;
    }

    protected void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        Template template;
        Template[] templates;
        TemplateContextType contextType = templateContext.getContextType();
        Template[] templateArray = templates = this.templateStore.getTemplates(contextType.getId());
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            template = templateArray[n2];
            if (template.getDescription().equals("Generate User Interface for all classes")) {
                template = this.buildUIGenerationTemplate(template, context);
            }
            ++n2;
        }
        templateArray = templates;
        n = templates.length;
        n2 = 0;
        while (n2 < n) {
            template = templateArray[n2];
            if (!acceptor.canAcceptMoreTemplates()) {
                return;
            }
            if (this.validate(template, templateContext)) {
                TemplateProposal proposal = this.createProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
                acceptor.accept(proposal);
            }
            ++n2;
        }
    }

    private Template buildUIGenerationTemplate(Template template, ContentAssistContext context) {
        EObject current = context.getCurrentModel();
        this.resourceSet = current.eResource().getResourceSet();
        String projectName = current.eResource().getURI().segment(1);
        URI primary = ResourceHelper.getPrimaryResourceURI((String)projectName);
        Resource primaryResource = ResourceHelper.loadResource((URI)primary, (ResourceSet)this.resourceSet);
        if (primaryResource == null) {
            throw new RuntimeException("could not locate primary resource with uri " + primary);
        }
        Viewpoint viewpoint = (Viewpoint)primaryResource.getContents().get(0);
        List dataResourceURIs = ResourceHelper.getSecondaryResourceURIsByExtension((String)"data.vptext", (String)projectName);
        block0: for (URI uri : dataResourceURIs) {
            List dataRoots = ResourceHelper.loadDataResource((URI)uri, (ResourceSet)this.resourceSet);
            if (dataRoots.isEmpty()) continue;
            for (EObject root : dataRoots) {
                if (!(root instanceof Data)) continue;
                Data data = (Data)root;
                TreeAppendable appendable = new TreeAppendable(current, "\t", "\n");
                EList vp_Classes = data.getVP_Classes();
                for (Class candidate : vp_Classes) {
                    this.generateUIForCurrentClass(candidate, viewpoint, data.getName(), appendable);
                }
                template.setPattern(appendable.getContent());
                continue block0;
            }
        }
        return template;
    }

    private void generateUIForCurrentClass(Class containingClass, Viewpoint vp, String prefix, TreeAppendable appendable) {
        String className = containingClass.getName();
        try {
            className = this.valueConverter.toString((Object)className, "FQN");
        }
        catch (ValueConverterException e) {
            e.printStackTrace();
        }
        appendable.append((CharSequence)"UI ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)" {");
        appendable.increaseIndentation().newLine();
        appendable.append((CharSequence)"label: \"").append((CharSequence)this.toLabel(vp.getShortName().replaceAll("\"", ""))).append((CharSequence)"\"");
        appendable.newLine();
        appendable.append((CharSequence)"Container ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)"_Section").append((CharSequence)" {");
        appendable.increaseIndentation().newLine();
        if (!containingClass.getVP_Class_Attributes().isEmpty()) {
            appendable.append((CharSequence)"Container ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)"_").append((CharSequence)"AttributeGroup").append((CharSequence)" {");
            appendable.increaseIndentation().newLine();
            appendable.append((CharSequence)"label: \"").append((CharSequence)this.toLabel(containingClass.getName())).append((CharSequence)" Attributes").append((CharSequence)"\"");
            for (Attribute attribute : containingClass.getVP_Class_Attributes()) {
                if (attribute.getOwned_type() instanceof LocalAttributeType) {
                    Enumeration enumeration = ((LocalAttributeType)attribute.getOwned_type()).getType();
                    this.generateRadioBoxUIEnumeration(enumeration, attribute, className, prefix, appendable);
                    continue;
                }
                if (!(attribute.getOwned_type() instanceof ExternalAttributeType)) continue;
                EDataType type = ResourceHelper.resolveDataType((EDataType)((ExternalAttributeType)attribute.getOwned_type()).getType(), (ResourceSet)this.resourceSet);
                String attributeName = attribute.getName();
                try {
                    attributeName = this.valueConverter.toString((Object)attributeName, "FQN");
                }
                catch (ValueConverterException e) {
                    e.printStackTrace();
                }
                if (type.getName().equals("EBoolean")) {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)attribute.getName()).append((CharSequence)"Field").append((CharSequence)" label: \"").append((CharSequence)this.toLabel(attribute.getName())).append((CharSequence)"\" type ").append((CharSequence)"checkbox").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
                    continue;
                }
                if (type.getName().equals("EEnumerator") || type instanceof EEnum) {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)attribute.getName()).append((CharSequence)"Field").append((CharSequence)" label: \"").append((CharSequence)this.toLabel(attribute.getName())).append((CharSequence)"\" type ").append((CharSequence)"radiobox").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
                    continue;
                }
                appendable.newLine().append((CharSequence)"Field ").append((CharSequence)attribute.getName()).append((CharSequence)"Field").append((CharSequence)" label: \"").append((CharSequence)this.toLabel(attribute.getName())).append((CharSequence)"\" type ").append((CharSequence)"text").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
            }
            appendable.decreaseIndentation().newLine();
            appendable.append((CharSequence)"}");
        }
        if (!containingClass.getVP_Classes_Associations().isEmpty()) {
            if (!containingClass.getVP_Class_Attributes().isEmpty()) {
                appendable.newLine();
            }
            appendable.append((CharSequence)"Container ").append((CharSequence)vp.getShortName().replaceAll("\"", "")).append((CharSequence)"_").append((CharSequence)containingClass.getName()).append((CharSequence)"_").append((CharSequence)"AssociationGroup").append((CharSequence)" {");
            appendable.increaseIndentation().newLine();
            appendable.append((CharSequence)"label: \"").append((CharSequence)this.toLabel(containingClass.getName())).append((CharSequence)" Associations").append((CharSequence)"\"");
            EList vp_Classes_Associations = containingClass.getVP_Classes_Associations();
            for (AbstractAssociation abs : vp_Classes_Associations) {
                String cardinality = abs.getCardinality().getName();
                if (cardinality.equals("One_Or_Many") || cardinality.equals("Nothing_Or_Many")) {
                    appendable.newLine().append((CharSequence)"Field ").append((CharSequence)abs.getName()).append((CharSequence)"Association").append((CharSequence)" label: \"").append((CharSequence)this.toLabel(abs.getName())).append((CharSequence)"\" type ").append((CharSequence)"multipleChoiceList").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)abs.getName());
                    continue;
                }
                appendable.newLine().append((CharSequence)"Field ").append((CharSequence)abs.getName()).append((CharSequence)"Association").append((CharSequence)" label: \"").append((CharSequence)this.toLabel(abs.getName())).append((CharSequence)"\" type ").append((CharSequence)"simpleChoiceList").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)abs.getName());
            }
            appendable.decreaseIndentation().newLine();
            appendable.append((CharSequence)"}");
        }
        appendable.decreaseIndentation().newLine();
        appendable.append((CharSequence)"}");
        appendable.decreaseIndentation().newLine();
        appendable.append((CharSequence)"}").newLine();
    }

    private void generateRadioBoxUIEnumeration(Enumeration enumeration, Attribute attribute, String className, String prefix, TreeAppendable appendable) {
        String attributeName = attribute.getName();
        try {
            attributeName = this.valueConverter.toString((Object)attributeName, "FQN");
        }
        catch (ValueConverterException e) {
            e.printStackTrace();
        }
        appendable.newLine().append((CharSequence)"Field ").append((CharSequence)enumeration.getName()).append((CharSequence)"Field").append((CharSequence)" label: \"").append((CharSequence)this.toLabel(enumeration.getName())).append((CharSequence)"\" type ").append((CharSequence)"radiobox").append((CharSequence)" , mapped-to ").append((CharSequence)prefix).append((CharSequence)".").append((CharSequence)className).append((CharSequence)".").append((CharSequence)attributeName);
    }
}

