/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.egf.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleActivatorHeader;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.osgi.framework.Version;
import org.polarsys.kitalpha.emde.egf.helper.ExtensionHelper;
import org.polarsys.kitalpha.emde.egf.l10n.Messages;
import org.polarsys.kitalpha.emde.extension.utils.ExtensionAnnotationsHelper;

public abstract class ManifestHelper {
    protected final GenModel genModel;
    private final IFile manifestFile;

    public static ManifestHelper createModelHelper(GenModel genModel) {
        return new ModelManifestHelper(genModel);
    }

    public static ManifestHelper createEditHelper(GenModel genModel) {
        return new EditManifestHelper(genModel);
    }

    public static ManifestHelper createEditorHelper(GenModel genModel) {
        return new EditorManifestHelper(genModel);
    }

    protected static IFile computeTargetFile(String projectDirectory) {
        Path path = new Path(projectDirectory);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(path.segment(0));
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        return file;
    }

    public ManifestHelper(GenModel genModel, IFile manifestFile) {
        this.genModel = genModel;
        this.manifestFile = manifestFile;
    }

    public void updateFile(IProgressMonitor monitor) {
        if (!this.isEnabled()) {
            return;
        }
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(this.manifestFile){

            protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    SubMonitor.convert((IProgressMonitor)innerMonitor, (String)NLS.bind((String)Messages.setupManifestMF, (Object)BundleHelper.getBundleId((IProject)ManifestHelper.this.manifestFile.getProject())), (int)100);
                    ManifestHelper.this.doUpdateFile(model);
                }
            }
        }, (IProgressMonitor)monitor);
    }

    protected void doUpdateFile(IBaseModel model) throws CoreException {
        this.processVersion((IBundlePluginModelBase)model);
        this.processImport((IBundlePluginModelBase)model, this.getRequiredPlugins());
    }

    protected abstract boolean isEnabled();

    protected abstract List<String> getRequiredPlugins();

    protected void processVersion(IBundlePluginModelBase model) {
        IBundle bundle = model.getBundleModel().getBundle();
        String pluginVersion = bundle.getHeader("Bundle-Version");
        if (pluginVersion == null) {
            pluginVersion = "1.0.0.qualifier";
            bundle.setHeader("Bundle-Version", pluginVersion);
        } else {
            Version version = Version.parseVersion((String)pluginVersion);
            if ("".equals(version.getQualifier())) {
                pluginVersion = String.valueOf(version.toString()) + ".qualifier";
                bundle.setHeader("Bundle-Version", pluginVersion);
            }
        }
    }

    protected void processImport(IBundlePluginModelBase model, List<String> importAdditions) throws CoreException {
        IPluginModelFactory factory = model.getPluginFactory();
        IPluginBase base = model.getPluginBase();
        HashSet<String> imports = new HashSet<String>();
        IPluginImport[] iPluginImportArray = base.getImports();
        int n = iPluginImportArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport plugin = iPluginImportArray[n2];
            imports.add(plugin.getId());
            ++n2;
        }
        for (String addition : importAdditions) {
            if (imports.contains(addition)) continue;
            IPluginImport plugin = factory.createImport();
            plugin.setId(addition);
            plugin.setName(addition);
            plugin.setReexported(true);
            base.add(plugin);
        }
    }

    private static class EditManifestHelper
    extends ManifestHelper {
        public EditManifestHelper(GenModel genModel) {
            super(genModel, EditManifestHelper.computeTargetFile(genModel.getEditProjectDirectory()));
        }

        @Override
        protected List<String> getRequiredPlugins() {
            ArrayList<String> additions = new ArrayList<String>();
            additions.addAll((Collection<String>)this.genModel.getEditPluginVariables());
            additions.add("org.polarsys.kitalpha.emde");
            for (GenPackage genPackage : this.genModel.getGenPackages()) {
                if (!genPackage.isChildCreationExtenders()) continue;
                for (String detail : ExtensionAnnotationsHelper.getUsedGenPackages((EPackage)genPackage.getEcorePackage())) {
                    EObject eObject;
                    if (detail == null) continue;
                    URI uri = URI.createURI((String)detail);
                    if (uri.isRelative()) {
                        uri = uri.resolve(genPackage.eResource().getURI());
                    }
                    if (!((eObject = this.genModel.eResource().getResourceSet().getEObject(uri, true)) instanceof GenPackage)) continue;
                    additions.add(((GenPackage)eObject).getGenModel().getModelPluginID());
                }
            }
            return additions;
        }

        @Override
        protected boolean isEnabled() {
            return this.genModel.isBundleManifest() && !this.genModel.sameEditEditorProject();
        }
    }

    private static class EditorManifestHelper
    extends ManifestHelper {
        public EditorManifestHelper(GenModel genModel) {
            super(genModel, EditorManifestHelper.computeTargetFile(genModel.getEditorProjectDirectory()));
        }

        @Override
        protected List<String> getRequiredPlugins() {
            ArrayList<String> additions = new ArrayList<String>();
            additions.addAll((Collection<String>)this.genModel.getEditorPluginVariables());
            additions.add("org.eclipse.emf.ecore.edit");
            additions.add("org.eclipse.emf.ecore.editor");
            additions.add("org.polarsys.kitalpha.emde.ui");
            additions.add("org.polarsys.kitalpha.ad.metadata");
            return additions;
        }

        @Override
        protected boolean isEnabled() {
            return this.genModel.isBundleManifest();
        }
    }

    private static class ModelManifestHelper
    extends ManifestHelper {
        public ModelManifestHelper(GenModel genModel) {
            super(genModel, ModelManifestHelper.computeTargetFile(genModel.getModelProjectDirectory()));
        }

        @Override
        protected List<String> getRequiredPlugins() {
            ArrayList<String> additions = new ArrayList<String>();
            additions.addAll((Collection<String>)this.genModel.getModelPluginVariables());
            if (ExtensionHelper.hasExtensibleProviderFactory(this.genModel) || ExtensionHelper.hasChildCreationExtenders(this.genModel)) {
                additions.add("org.polarsys.kitalpha.emde.xmi");
            }
            return additions;
        }

        @Override
        protected boolean isEnabled() {
            return this.genModel.isBundleManifest() && this.genModel.hasPluginSupport() && !this.genModel.sameModelEditProject() && !this.genModel.sameModelEditorProject();
        }

        @Override
        protected void doUpdateFile(IBaseModel model) throws CoreException {
            super.doUpdateFile(model);
            this.processActivator((IBundlePluginModelBase)model);
        }

        protected void processActivator(IBundlePluginModelBase model) {
            IBundle bundle = model.getBundleModel().getBundle();
            String activator = this.genModel.hasModelPluginClass() ? String.valueOf(this.genModel.getQualifiedModelPluginClassName()) + "$Implementation" : null;
            IManifestHeader header = bundle.getManifestHeader("Bundle-Activator");
            if (header != null && header instanceof BundleActivatorHeader) {
                ((BundleActivatorHeader)header).setClassName(activator);
            } else {
                if (bundle.getHeader("Bundle-Activator") == null && activator == null) {
                    return;
                }
                bundle.setHeader("Bundle-Activator", activator);
            }
        }
    }
}

