/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.action;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecoretools.design.EcoreToolsViewpoints;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.OpenRepresentationsFileJob;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateRepresentationWizard;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateSessionResourceWizard;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class EcoreInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private URI domainModelURI;
    private IProject containingProject;
    private IStructuredSelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.domainModelURI = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        this.selection = (IStructuredSelection)selection;
        if (this.selection.getFirstElement() instanceof IFile) {
            IFile file = (IFile)this.selection.getFirstElement();
            this.containingProject = file.getProject();
            this.domainModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            action.setEnabled(true);
        }
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        Option prj;
        Session existingSession = null;
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            ResourceSet set = session.getTransactionalEditingDomain().getResourceSet();
            for (Resource res : set.getResources()) {
                if (res.getURI() == null || !set.getURIConverter().normalize(res.getURI()).equals(set.getURIConverter().normalize(this.domainModelURI))) continue;
                existingSession = session;
            }
        }
        if (existingSession == null && (prj = ModelingProject.asModelingProject((IProject)this.containingProject)).some()) {
            Option optionalMainSessionFileURI;
            existingSession = ((ModelingProject)prj.get()).getSession();
            if (existingSession == null && (optionalMainSessionFileURI = ((ModelingProject)prj.get()).getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor(), false, false)).some()) {
                ModelingProjectManager.INSTANCE.loadAndOpenRepresentationsFile((URI)optionalMainSessionFileURI.get());
            }
            if (OpenRepresentationsFileJob.shouldWaitOtherJobs()) {
                try {
                    Job.getJobManager().join((Object)"org.eclipse.sirius.representationsFile", (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException interruptedException) {}
            }
            if ((existingSession = ((ModelingProject)prj.get()).getSession()) != null) {
                existingSession.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(existingSession.getTransactionalEditingDomain()){

                    protected void doExecute() {
                        ((ModelingProject)prj.get()).getSession().addSemanticResource(EcoreInitDiagramFileAction.this.domainModelURI, (IProgressMonitor)new NullProgressMonitor());
                    }
                });
                existingSession.addSemanticResource(this.domainModelURI, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        if (existingSession == null) {
            existingSession = this.createSession();
        }
        if (existingSession != null) {
            this.openCreateRepresentationWizard(existingSession);
        }
    }

    private Session createSession() {
        final CreateSessionResourceWizard wizard = new CreateSessionResourceWizard(this.selection);
        wizard.init(PlatformUI.getWorkbench(), this.selection);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText("Create Representation File");
        if (dialog.open() == 0) {
            wizard.getCreatedSession().getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(wizard.getCreatedSession().getTransactionalEditingDomain()){

                protected void doExecute() {
                    wizard.getCreatedSession().addSemanticResource(EcoreInitDiagramFileAction.this.domainModelURI, (IProgressMonitor)new NullProgressMonitor());
                }
            });
            return wizard.getCreatedSession();
        }
        return null;
    }

    protected void openCreateRepresentationWizard(final Session existingSession) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(existingSession);
        uiSession.open();
        existingSession.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(existingSession.getTransactionalEditingDomain()){

            protected void doExecute() {
                Set fromEcoreTools = EcoreToolsViewpoints.fromViewpointRegistry().all();
                ViewpointSelectionCallback selection = new ViewpointSelectionCallback();
                for (Viewpoint previouslySelected : existingSession.getSelectedViewpoints(false)) {
                    if (!fromEcoreTools.contains(previouslySelected)) continue;
                    selection.deselectViewpoint(previouslySelected, existingSession, (IProgressMonitor)new NullProgressMonitor());
                }
                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().design(), existingSession, new NullProgressMonitor());
                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().review(), existingSession, new NullProgressMonitor());
                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().archetype(), existingSession, new NullProgressMonitor());
                this.selectViewpoint(selection, EcoreToolsViewpoints.fromViewpointRegistry().generation(), existingSession, new NullProgressMonitor());
            }

            private void selectViewpoint(ViewpointSelectionCallback selection, Viewpoint vp, Session session, NullProgressMonitor progressMonitor) {
                if (vp != null) {
                    selection.selectViewpoint(vp, session, (IProgressMonitor)progressMonitor);
                }
            }
        });
        CreateRepresentationWizard wizard = new CreateRepresentationWizard(existingSession);
        wizard.init();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText("Create Representation Wizard");
        dialog.open();
    }
}

