/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.resourcereuse.emfscheme.dialog.Messages;
import org.polarsys.kitalpha.resourcereuse.emfscheme.dialog.services.GeneralServices;
import org.polarsys.kitalpha.resourcereuse.emfscheme.utils.context.ModelReuseContext;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.ui.Activator;

public class LoadingResourceReuseDialog
extends Dialog {
    EObject selection;
    Text idText;
    SearchCriteria criteria = new SearchCriteria();
    String wordTyped = "";
    protected Table resultsTable;
    boolean addButtonPressed = false;
    Text nameText;
    Text domainText;
    Text versionText;
    String uriText;
    private final List<GeneralServices.StringValue> tags = new ArrayList<GeneralServices.StringValue>();
    private boolean okEnabled = false;

    public LoadingResourceReuseDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.firstPageTittle);
        shell.setImage(GeneralServices.getParentImage());
        shell.setMinimumSize(800, 600);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        main.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 300;
        layoutData.minimumWidth = 100;
        main.setLayoutData((Object)layoutData);
        this.createFilterGroup(main);
        this.createResultsGroup(main);
        this.setUpListeners();
        return super.createDialogArea(parent);
    }

    private void setUpListeners() {
        this.idText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (LoadingResourceReuseDialog.this.idText.getCharCount() != 0) {
                    LoadingResourceReuseDialog.this.criteria.setId(String.valueOf(LoadingResourceReuseDialog.this.idText.getText(0, LoadingResourceReuseDialog.this.idText.getCharCount())) + ".*");
                } else {
                    LoadingResourceReuseDialog.this.criteria.setId(".*");
                }
                GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.nameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (LoadingResourceReuseDialog.this.nameText.getCharCount() != 0) {
                    LoadingResourceReuseDialog.this.criteria.setName(String.valueOf(LoadingResourceReuseDialog.this.nameText.getText(0, LoadingResourceReuseDialog.this.nameText.getCharCount())) + ".*");
                } else {
                    LoadingResourceReuseDialog.this.criteria.setName("");
                }
                GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.domainText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (LoadingResourceReuseDialog.this.domainText.getCharCount() != 0) {
                    LoadingResourceReuseDialog.this.criteria.setDomain(String.valueOf(LoadingResourceReuseDialog.this.domainText.getText(0, LoadingResourceReuseDialog.this.domainText.getCharCount())) + ".*");
                } else {
                    LoadingResourceReuseDialog.this.criteria.setDomain("");
                }
                GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.versionText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (LoadingResourceReuseDialog.this.versionText.getCharCount() != 0) {
                    LoadingResourceReuseDialog.this.criteria.setVersion(LoadingResourceReuseDialog.this.versionText.getText(0, LoadingResourceReuseDialog.this.versionText.getCharCount()));
                } else {
                    LoadingResourceReuseDialog.this.criteria.setVersion("");
                }
                GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.resultsTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] resultSelection = LoadingResourceReuseDialog.this.resultsTable.getSelection();
                if (resultSelection.length >= 1) {
                    LoadingResourceReuseDialog.this.updateOKState(true);
                } else {
                    LoadingResourceReuseDialog.this.updateOKState(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.resultsTable.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                LoadingResourceReuseDialog.this.okPressed();
            }
        });
    }

    public void setSelection(EObject selection) {
        this.selection = selection;
    }

    protected void updateOKState(boolean state) {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed() && state != this.okEnabled) {
            okButton.setEnabled(state);
            this.okEnabled = state;
        }
    }

    protected void okPressed() {
        ModelReuseContext context = ModelReuseContext.INSTANCE;
        Session session = SessionManager.INSTANCE.getSession(this.selection);
        context.setSession(session);
        context.resetCriterias();
        TableItem[] tableItemArray = this.resultsTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem currentItem = tableItemArray[n2];
            SearchCriteria settedCriteria = (SearchCriteria)currentItem.getData();
            context.addCriteria(settedCriteria);
            ++n2;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void createFilterGroup(Composite parent) {
        Group filterGroup = new Group(parent, 4);
        GridData layoutData = new GridData(1808);
        GridLayout layoutFilterGroup = new GridLayout();
        layoutFilterGroup.numColumns = 2;
        filterGroup.setText(Messages.filtersPartLabel);
        filterGroup.setLayout((Layout)layoutFilterGroup);
        layoutData.minimumHeight = 400;
        filterGroup.setLayoutData((Object)layoutData);
        Composite filter = new Composite((Composite)filterGroup, 0);
        GridLayout filterCompositeLayout = new GridLayout();
        filterCompositeLayout.numColumns = 1;
        filter.setLayout((Layout)filterCompositeLayout);
        filter.setLayoutData((Object)new GridData(1808));
        this.buildFiltersContents(filterGroup, filter);
    }

    private void buildFiltersContents(Group filterGroup, Composite filter) {
        Label idLabel = new Label(filter, 0);
        idLabel.setText(Messages.idFilterLabel);
        idLabel.setLayoutData((Object)new GridData());
        this.idText = new Text(filter, 2048);
        this.idText.setText(".*");
        this.idText.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(filter, 0);
        nameLabel.setText(Messages.nameFilterLabel);
        nameLabel.setLayoutData((Object)new GridData());
        this.nameText = new Text(filter, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        Label domainLabel = new Label(filter, 0);
        domainLabel.setText(Messages.domainFilterLabel);
        domainLabel.setLayoutData((Object)new GridData());
        this.domainText = new Text(filter, 2048);
        this.domainText.setLayoutData((Object)new GridData(768));
        Label versionLabel = new Label(filter, 0);
        versionLabel.setText(Messages.versionFilterLabel);
        versionLabel.setLayoutData((Object)new GridData());
        this.versionText = new Text(filter, 2048);
        this.versionText.setLayoutData((Object)new GridData(768));
        this.tags.addAll(GeneralServices.toStringValueList(this.criteria.getTags()));
        this.createTagsTableComposite(filter, this.tags, "newTag", String.valueOf(org.polarsys.kitalpha.resourcereuse.ui.Messages.tags_Field_Label) + ':', org.polarsys.kitalpha.resourcereuse.ui.Messages.tags_Field__AddButton_Label, org.polarsys.kitalpha.resourcereuse.ui.Messages.tags_Field__DeleteButton_Label);
    }

    protected void createTagsTableComposite(Composite parent, final List<GeneralServices.StringValue> data, final String defaultValue, String tableLabel, String addLabel, String deleteLabel) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(tableLabel);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        final TableViewer viewer = new TableViewer(composite);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setColumnProperties(new String[]{"name"});
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)viewer.getTable())});
        viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                GeneralServices.StringValue tag = (GeneralServices.StringValue)tableItem.getData();
                tag.value = value.toString();
                if (!LoadingResourceReuseDialog.this.criteria.getTags().contains(tag.value)) {
                    if (LoadingResourceReuseDialog.this.addButtonPressed) {
                        LoadingResourceReuseDialog.this.criteria.getTags().add(tag.value);
                        LoadingResourceReuseDialog.this.addButtonPressed = false;
                    } else {
                        LoadingResourceReuseDialog.this.criteria.getTags().remove(tableItem.getText());
                        LoadingResourceReuseDialog.this.criteria.getTags().add(tag.value);
                    }
                    boolean currentTagFitWithModels = GeneralServices.checkIfCurrentTagFitsWithModels(tag.value, LoadingResourceReuseDialog.this.getParentShell());
                    if (currentTagFitWithModels) {
                        GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
                    } else {
                        data.clear();
                        LoadingResourceReuseDialog.this.criteria.getTags().remove(tag.value);
                        List<GeneralServices.StringValue> stringValueList = GeneralServices.toStringValueList(LoadingResourceReuseDialog.this.criteria.getTags());
                        data.addAll(stringValueList);
                        if (!data.isEmpty()) {
                            GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
                        } else {
                            SearchCriteria temp = new SearchCriteria();
                            temp.setId(".*");
                            GeneralServices.refreshResultsAccordingToCriteria(temp, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
                        }
                    }
                } else if (LoadingResourceReuseDialog.this.addButtonPressed) {
                    GeneralServices.constructDialogForExistingTag(tag.value, LoadingResourceReuseDialog.this.getParentShell());
                    LoadingResourceReuseDialog.this.criteria.getTags().add(tag.value);
                    LoadingResourceReuseDialog.this.addButtonPressed = false;
                    GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
                }
                viewer.refresh();
            }

            public Object getValue(Object element, String property) {
                GeneralServices.StringValue tag = (GeneralServices.StringValue)element;
                return tag.value;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        viewer.setInput(data);
        Composite btnComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        btnComposite.setLayout((Layout)layout);
        btnComposite.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(btnComposite, 8);
        addButton.setLayoutData((Object)new GridData());
        addButton.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        addButton.setToolTipText(addLabel);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                data.add(new GeneralServices.StringValue(defaultValue));
                LoadingResourceReuseDialog.this.addButtonPressed = true;
                viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button deleteButton = new Button(btnComposite, 8);
        deleteButton.setLayoutData((Object)new GridData());
        deleteButton.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        deleteButton.setToolTipText(deleteLabel);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] array;
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object[] objectArray = array = selection.toArray();
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    data.remove(obj);
                    String tagsToRemove = obj.toString();
                    LoadingResourceReuseDialog.this.criteria.getTags().remove(tagsToRemove);
                    ++n2;
                }
                viewer.refresh();
                deleteButton.setEnabled(false);
                GeneralServices.refreshResultsAccordingToCriteria(LoadingResourceReuseDialog.this.criteria, LoadingResourceReuseDialog.this.resultsTable, LoadingResourceReuseDialog.this.getParentShell());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    private void createResultsGroup(Composite parent) {
        Group resultGroup = new Group(parent, 4);
        GridData layoutDataResult = new GridData(1808);
        resultGroup.setText(Messages.resultsLabel);
        GridLayout layoutResultGroup = new GridLayout();
        layoutResultGroup.numColumns = 1;
        resultGroup.setLayout((Layout)layoutResultGroup);
        resultGroup.setLayoutData((Object)layoutDataResult);
        this.resultsTable = new Table((Composite)resultGroup, 2818);
        GridData resultListLayoutData = new GridData(1808);
        resultListLayoutData.heightHint = 12 * this.resultsTable.getItemHeight();
        this.resultsTable.setLayoutData((Object)resultListLayoutData);
        this.criteria = new SearchCriteria();
        this.criteria.setId(this.idText.getText());
        GeneralServices.refreshResultsAccordingToCriteria(this.criteria, this.resultsTable, this.getParentShell());
    }

    protected Control createButtonBar(Composite parent) {
        Control temp = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return temp;
    }
}

