/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistryListener;
import org.eclipse.sirius.ext.base.relations.DependencyTracker;
import org.eclipse.sirius.ext.base.relations.Relation;

public class ViewpointDependenciesTracker
extends DependencyTracker<URI> {
    private final ViewpointRegistry registry;
    private final TrackerUpdater updater;

    public ViewpointDependenciesTracker(ViewpointRegistry registry) {
        this(registry, ((ViewpointRegistry)Preconditions.checkNotNull((Object)registry)).getRelations().getTransitiveRequires());
    }

    public ViewpointDependenciesTracker(ViewpointRegistry registry, Relation<URI> relation) {
        super((Relation)Preconditions.checkNotNull(relation));
        this.registry = (ViewpointRegistry)Preconditions.checkNotNull((Object)registry);
        this.updater = new TrackerUpdater();
        this.registry.addListener(this.updater);
    }

    public void dispose() {
        this.registry.removeListener(this.updater);
    }

    private class TrackerUpdater
    implements ViewpointRegistryListener {
        private TrackerUpdater() {
        }

        @Override
        public void registryChanged(ViewpointRegistry reg, Set<URI> removed, Set<URI> added, Set<URI> changed) {
            for (URI r : removed) {
                ViewpointDependenciesTracker.this.remove(r);
            }
            for (URI a : added) {
                ViewpointDependenciesTracker.this.add(a);
            }
            for (URI c : changed) {
                ViewpointDependenciesTracker.this.update(c);
            }
        }
    }
}

