/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.task;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.constant.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.extension.data.LauncherExtension;

public class ExtensionsCollectorTask
implements ITaskProduction {
    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String extensionPointID_Value = (String)productionContext.getInputValue((Object)"extension.point.id", String.class);
        String configurationElementName_Value = (String)productionContext.getInputValue((Object)"extension.configuration.element.name", String.class);
        String extensionFCoreAttributeName_Value = (String)productionContext.getInputValue((Object)"extension.fcore.attribute.name", String.class);
        if (extensionPointID_Value == null) {
            throw new IllegalArgumentException(Messages.Contract_ExtensionPointId);
        }
        if (configurationElementName_Value == null) {
            throw new IllegalArgumentException(Messages.Contract_ExtensionConfigurationElementName);
        }
        if (extensionFCoreAttributeName_Value == null) {
            throw new IllegalArgumentException(Messages.Contract_ExtensionFcoreAttributeName);
        }
        List<IExtension> availableExtensions = this.getAvailavleExtension(extensionPointID_Value);
        ArrayList<LauncherExtension> extensions = new ArrayList<LauncherExtension>();
        for (IExtension iExtension : availableExtensions) {
            extensions.add(new LauncherExtension(iExtension, configurationElementName_Value, extensionFCoreAttributeName_Value));
        }
        productionContext.setOutputValue((Object)"extension.point.contributions", extensions);
    }

    private List<IExtension> getAvailavleExtension(String extensionPointID) {
        IExtension[] tExtensions = Platform.getExtensionRegistry().getExtensionPoint(extensionPointID).getExtensions();
        ArrayList<IExtension> aExtensions = new ArrayList<IExtension>();
        if (tExtensions.length > 0) {
            IExtension[] iExtensionArray = tExtensions;
            int n = tExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension iExtension = iExtensionArray[n2];
                aExtensions.add(iExtension);
                ++n2;
            }
        }
        return aExtensions;
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

