/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.AbstractRepresentationDialectServices;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.contribution.ContributionPointHelper;
import org.eclipse.sirius.business.internal.contribution.IncrementalModelContributor;
import org.eclipse.sirius.business.internal.contribution.IntrinsicPathIdentifier;
import org.eclipse.sirius.business.internal.contribution.ModelContributorAdapter;
import org.eclipse.sirius.business.internal.contribution.ReferenceResolver;
import org.eclipse.sirius.business.internal.contribution.RepresentationExtensionsFinder;
import org.eclipse.sirius.business.internal.contribution.SiriusReferenceResolver;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.description.contribution.ContributionPoint;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.table.business.internal.dialect.ContributionTrakingIdentifier;
import org.eclipse.sirius.table.business.internal.dialect.TableContributionsFinder;
import org.eclipse.sirius.table.business.internal.dialect.TableModelContributor;
import org.eclipse.sirius.table.business.internal.dialect.description.TableInterpretedExpressionQuery;
import org.eclipse.sirius.table.business.internal.refresh.DTableElementSynchronizerSpec;
import org.eclipse.sirius.table.business.internal.refresh.DTableSynchronizerImpl;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.table.tools.internal.command.TableCommandFactory;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class TableDialectServices
extends AbstractRepresentationDialectServices {
    public static boolean isHandledByMovida(DRepresentation representation) {
        return Movida.isEnabled() && representation instanceof DTable && ((DTable)representation).getDescription() instanceof EditionTableDescription;
    }

    protected boolean isSupported(DRepresentation representation) {
        return representation instanceof DTable;
    }

    protected boolean isSupported(DRepresentationDescriptor representationDescriptor) {
        return representationDescriptor.getDescription() instanceof TableDescription;
    }

    protected boolean isSupported(RepresentationDescription description) {
        return description instanceof TableDescription;
    }

    public boolean canCreate(EObject semantic, RepresentationDescription desc) {
        Session session;
        boolean result = false;
        if (semantic != null && this.isSupported(desc) && ((session = new EObjectQuery(semantic).getSession()) == null || this.isRelatedViewpointSelected(session, desc))) {
            TableDescription tableDesc = (TableDescription)desc;
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
            if (accessor != null) {
                result = this.checkDomainClass(accessor, semantic, tableDesc.getDomainClass());
            }
            result = result && this.checkPrecondition(semantic, tableDesc.getPreconditionExpression());
        }
        return result;
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, IProgressMonitor monitor) {
        DTable table = null;
        try {
            monitor.beginTask(MessageFormat.format(Messages.TableDialectServices_CreateTable, name), 11);
            monitor.subTask(MessageFormat.format(Messages.TableDialectServices_CreateTable, name));
            table = TableFactory.eINSTANCE.createDTable();
            table.setName(name);
            table.setTarget(semantic);
            table.setDescription((TableDescription)description);
            if (TableDialectServices.isHandledByMovida(table)) {
                this.refreshEffectiveRepresentationDescription(table, monitor);
            }
            monitor.worked(1);
            this.refresh(table, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
        return table;
    }

    public void updateRepresentationsExtendedBy(Session session, Viewpoint viewpoint, boolean activated) {
        if (Movida.isEnabled()) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            for (DView view : session.getOwnedViews()) {
                for (DRepresentation representation : new DViewQuery(view).getLoadedRepresentations()) {
                    RepresentationExtensionsFinder ref;
                    if (!TableDialectServices.isHandledByMovida(representation) || !(ref = new RepresentationExtensionsFinder((RepresentationDescription)((DTable)representation).getDescription())).isAffectedBy(viewpoint)) continue;
                    this.refreshEffectiveRepresentationDescription(representation, (IProgressMonitor)monitor);
                    this.refresh(representation, (IProgressMonitor)monitor);
                }
            }
        }
    }

    public void refreshEffectiveRepresentationDescription(DRepresentation representation, IProgressMonitor monitor) {
        if (!TableDialectServices.isHandledByMovida(representation)) {
            return;
        }
        DTable table = (DTable)representation;
        Session session = SessionManager.INSTANCE.getSession(table.getTarget());
        IncrementalModelContributor imc = this.getModelContributor(session, table);
        imc.apply((EObject)table.getDescription(), (Collection)new RepresentationExtensionsFinder((RepresentationDescription)table.getDescription()).findAllRelevantViewpoints(session));
        Supplier<EObject> efSupplier = new Supplier<EObject>(){

            public EObject get() {
                return null;
            }
        };
        Supplier<EList<ContributionPoint>> cpSupplier = new Supplier<EList<ContributionPoint>>(){

            public EList<ContributionPoint> get() {
                return null;
            }
        };
        this.updateContributionPoints(table, efSupplier, cpSupplier, imc);
    }

    private IncrementalModelContributor getModelContributor(Session session, DTable table) {
        ModelContributorAdapter mca = ModelContributorAdapter.find((EObject)table);
        if (mca == null) {
            mca = ModelContributorAdapter.attach((EObject)table, (IncrementalModelContributor)this.createModelContributor(session, table));
        }
        return mca.getModelContributor();
    }

    private IncrementalModelContributor createModelContributor(Session session, DTable table) {
        Supplier<EObject> efSupplier = new Supplier<EObject>(){

            public EObject get() {
                return null;
            }
        };
        Supplier<Iterable<ContributionPoint>> cpSupplier = new Supplier<Iterable<ContributionPoint>>(){

            public Iterable<ContributionPoint> get() {
                return null;
            }
        };
        SiriusReferenceResolver resolver = new SiriusReferenceResolver(session.getInterpreter());
        ContributionTrakingIdentifier idFunction = new ContributionTrakingIdentifier(efSupplier, cpSupplier, (Function<EObject, String>)new IntrinsicPathIdentifier());
        TableModelContributor imc = new TableModelContributor(new TableContributionsFinder(table.getDescription()), (ReferenceResolver)resolver, idFunction);
        if (efSupplier.get() != null) {
            HashMap restoredIdentifiers = Maps.newHashMap();
            for (EObject obj : AllContents.of((EObject)((EObject)efSupplier.get()), (boolean)true)) {
                restoredIdentifiers.put(obj, idFunction.apply(obj));
            }
            imc.resetState((EObject)efSupplier.get(), restoredIdentifiers);
        }
        return imc;
    }

    private void updateContributionPoints(DTable table, Supplier<EObject> efSupplier, Supplier<EList<ContributionPoint>> cpSupplier, IncrementalModelContributor imc) {
        ArrayList newPoints = Lists.newArrayList();
        newPoints.add(ContributionPointHelper.make((EObject)((EObject)efSupplier.get()), (String)new IntrinsicPathIdentifier().apply((EObject)table.getDescription())));
        Map cps = imc.getContributionPoints();
        for (Map.Entry entry : cps.entrySet()) {
            newPoints.add(ContributionPointHelper.make((EObject)((EObject)entry.getKey()), (String)((String)entry.getValue())));
        }
        for (EObject imported : ((TableDescription)efSupplier.get()).getImportedElements()) {
            newPoints.add(ContributionPointHelper.make((EObject)imported, (String)((String)imc.getIdentifier(imported))));
        }
        ContributionPointHelper.updateIfNeeded((EList)((EList)cpSupplier.get()), (List)newPoints);
    }

    public void refresh(DRepresentation representation, boolean fullRefresh, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.TableDialectServices_RefreshTable, 1);
            DTable table = (DTable)representation;
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(table.getTarget());
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
            Supplier<EObject> efSupplier = new Supplier<EObject>(){

                public EObject get() {
                    return null;
                }
            };
            if (TableDialectServices.isHandledByMovida(table) && efSupplier.get() == null) {
                this.refreshEffectiveRepresentationDescription(representation, monitor);
                monitor.worked(1);
            }
            TableDescription description = TableDialectServices.isHandledByMovida(table) ? (TableDescription)efSupplier.get() : table.getDescription();
            DTableSynchronizerImpl sync = new DTableSynchronizerImpl(description, accessor, interpreter);
            sync.setTable(table);
            sync.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public void refreshImpactedElements(DRepresentation representation, Collection<Notification> notifications, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.TableDialectServices_RefreshTable, 10);
            DTable table = (DTable)representation;
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(table.getTarget());
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
            Set<DTableElement> dTableElements = this.getTableElementsToRefresh(notifications, table);
            monitor.worked(2);
            DTableElementSynchronizerSpec synchronizer = new DTableElementSynchronizerSpec(accessor, interpreter);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 8);
            try {
                subMonitor.beginTask(Messages.TableDialectServices_RefreshImpactedElements, dTableElements.size());
                for (DTableElement dTableElement : dTableElements) {
                    if (dTableElement instanceof DCell) {
                        synchronizer.refresh((DCell)dTableElement);
                    } else if (dTableElement instanceof DLine) {
                        synchronizer.refresh((DLine)dTableElement);
                        synchronizer.refreshSemanticElements(dTableElement, ((DLine)dTableElement).getOriginMapping());
                    } else if (dTableElement instanceof DColumn) {
                        synchronizer.refresh((DColumn)dTableElement);
                        synchronizer.refreshSemanticElements(dTableElement, ((DColumn)dTableElement).getOriginMapping());
                    }
                    subMonitor.worked(1);
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private Set<DTableElement> getTableElementsToRefresh(Collection<Notification> notifications, DTable table) {
        HashSet tableElementsToRefresh = Sets.newHashSet();
        Session session = new EObjectQuery(table.getTarget()).getSession();
        if (session != null) {
            ECrossReferenceAdapter xref = session.getSemanticCrossReferencer();
            HashSet alreadyDoneNotifiers = Sets.newHashSet();
            for (Notification notification : notifications) {
                EObject eObjectNotifier;
                Object notifier = notification.getNotifier();
                if (!(notifier instanceof EObject) || !alreadyDoneNotifiers.add(eObjectNotifier = (EObject)notifier)) continue;
                tableElementsToRefresh.addAll(this.getTableElementsToRefresh(eObjectNotifier, table, xref));
            }
        }
        return tableElementsToRefresh;
    }

    private Set<DTableElement> getTableElementsToRefresh(EObject notifier, DTable table, ECrossReferenceAdapter xref) {
        HashSet tableElementsToRefresh = Sets.newHashSet();
        Collection inverseReferencers = new EObjectQuery(notifier, xref).getInverseReferences(REPRESENTATION_ELEMENTS_INVERSE_REFERENCES);
        for (EObject inverseReferencer : inverseReferencers) {
            DTableElement tableElement;
            if (!(inverseReferencer instanceof DTableElement) || !this.isContainedWithinCurrentTable(tableElement = (DTableElement)inverseReferencer, table)) continue;
            tableElementsToRefresh.add(tableElement);
        }
        return tableElementsToRefresh;
    }

    private boolean isContainedWithinCurrentTable(DTableElement tableElement, DTable table) {
        return table == new DRepresentationElementQuery((DRepresentationElement)tableElement).getParentRepresentation();
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        if (this.isSupported(representation)) {
            return ((DTable)representation).getDescription();
        }
        return null;
    }

    public void initRepresentations(Viewpoint vp, EObject semantic, IProgressMonitor monitor) {
        super.initRepresentations(semantic, vp, TableDescription.class, monitor);
    }

    protected <T extends RepresentationDescription> void initRepresentationForElement(T representationDescription, EObject semanticElement, IProgressMonitor monitor) {
        TableDescription tableDescription;
        if (representationDescription instanceof TableDescription && this.shouldInitializeRepresentation(semanticElement, tableDescription = (TableDescription)representationDescription, tableDescription.getDomainClass())) {
            ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticElement);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)semanticElement);
            if (modelAccessor.eInstanceOf(semanticElement, tableDescription.getDomainClass())) {
                boolean canCreate = true;
                if (tableDescription.getPreconditionExpression() != null && !StringUtil.isEmpty((String)tableDescription.getPreconditionExpression())) {
                    try {
                        canCreate = InterpreterUtil.getInterpreter((EObject)semanticElement).evaluateBoolean(semanticElement, tableDescription.getPreconditionExpression());
                    }
                    catch (EvaluationException evaluationException) {
                        canCreate = false;
                    }
                }
                if (canCreate) {
                    try {
                        monitor.beginTask(MessageFormat.format(Messages.TableDialectServices_InitializeTable, new IdentifiedElementQuery(representationDescription).getLabel()), 1);
                        TableCommandFactory tableCommandFactory = new TableCommandFactory(domain);
                        tableCommandFactory.setModelAccessor(modelAccessor);
                        DCommand command = tableCommandFactory.buildCreateTableFromDescription(tableDescription, semanticElement, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        domain.getCommandStack().execute((Command)command);
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
    }

    public DRepresentation copyRepresentation(DRepresentation representation, String name, Session session, IProgressMonitor monitor) {
        DRepresentation newRepresentation = super.copyRepresentation(representation, name, session, monitor);
        session.getServices().putCustomData("DREPRESENTATION", ((DSemanticDecorator)representation).getTarget(), (EObject)newRepresentation);
        return newRepresentation;
    }

    public IInterpretedExpressionQuery createInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        return new TableInterpretedExpressionQuery(target, feature);
    }

    public boolean handles(RepresentationDescription representationDescription) {
        return representationDescription instanceof TableDescription;
    }

    public boolean handles(RepresentationExtensionDescription representationExtensionDescription) {
        return false;
    }
}

