/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractCompositeEObjectPropertySource
implements IPropertySource {
    private Map<EObjectIndexer, IPropertySource> propertySources = new TreeMap<EObjectIndexer, IPropertySource>();
    private Map<EObject, String> categoryNames = new HashMap<EObject, String>();

    public void addPropertySource(EObject eObject, IPropertySource propertySource) {
        EObjectIndexer eObjectIndexer = this.findEObjectIndexerFromEObject(eObject);
        if (eObjectIndexer != null) {
            IPropertySource existedPropertySource = this.propertySources.get(eObjectIndexer);
            DelegatingCompositePropertySource delegatingCompositePropertySource = new DelegatingCompositePropertySource();
            delegatingCompositePropertySource.addPropertySource(existedPropertySource);
            delegatingCompositePropertySource.addPropertySource(propertySource);
            this.propertySources.put(eObjectIndexer, delegatingCompositePropertySource);
        } else {
            eObjectIndexer = new EObjectIndexer(this.propertySources.size(), eObject);
            this.propertySources.put(eObjectIndexer, propertySource);
        }
    }

    public Object getEditableValue() {
        return this.propertySources;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        LinkedList<IPropertyDescriptor> propertyDescriptors = new LinkedList<IPropertyDescriptor>();
        for (Map.Entry<EObjectIndexer, IPropertySource> entry : this.propertySources.entrySet()) {
            IPropertySource currentSource = entry.getValue();
            EObject editableValue = entry.getKey().getEObject();
            propertyDescriptors.addAll(AbstractCompositeEObjectPropertySource.getDecoratedPropertiesDescriptor(currentSource, this.buildCategoryName(editableValue), editableValue));
        }
        return propertyDescriptors.toArray(new IPropertyDescriptor[propertyDescriptors.size()]);
    }

    private static List<IPropertyDescriptor> getDecoratedPropertiesDescriptor(IPropertySource propertySource, String categoryName, EObject eObject) {
        IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
        ArrayList<IPropertyDescriptor> descriptorsList = new ArrayList<IPropertyDescriptor>(descriptors.length);
        IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
            descriptorsList.add(new PropertyDescriptorDecorator(descriptor, categoryName, eObject));
            ++n2;
        }
        return descriptorsList;
    }

    public Object getPropertyValue(Object id) {
        Identifier identifier = (Identifier)id;
        return this.getPropertySource(identifier).getPropertyValue(identifier.getId());
    }

    public boolean isPropertySet(Object id) {
        Identifier identifier = (Identifier)id;
        return this.getPropertySource(identifier).isPropertySet(identifier.getId());
    }

    public void resetPropertyValue(Object id) {
        Identifier identifier = (Identifier)id;
        this.getPropertySource(identifier).resetPropertyValue(identifier.getId());
    }

    public void setPropertyValue(Object id, Object value) {
        Identifier identifier = (Identifier)id;
        this.getPropertySource(identifier).setPropertyValue(identifier.getId(), value);
    }

    protected String buildCategoryName(EObject eObject) {
        if (this.categoryNames.containsKey(eObject)) {
            this.categoryNames.remove(eObject);
        }
        String result = null;
        AdapterFactory factory = this.getItemProvidersAdapterFactory();
        IItemLabelProvider labelProvider = (IItemLabelProvider)factory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (labelProvider != null) {
            result = labelProvider.getText((Object)eObject);
        } else {
            String name;
            result = eObject.eClass().getName();
            EStructuralFeature nameStructuralFeature = eObject.eClass().getEStructuralFeature("name");
            if (nameStructuralFeature != null && (name = (String)eObject.eGet(nameStructuralFeature)) != null) {
                result = String.valueOf(result) + " " + name;
            }
        }
        if (result == null) {
            result = "";
        }
        String resultTmp = result;
        int i = 2;
        while (this.categoryNames.values().contains(resultTmp)) {
            resultTmp = String.valueOf(result) + " " + i++;
        }
        result = resultTmp;
        this.categoryNames.put(eObject, result);
        return result;
    }

    protected abstract AdapterFactory getItemProvidersAdapterFactory();

    protected IPropertySource getPropertySource(Identifier identifier) {
        IPropertySource result = null;
        EObjectIndexer indexer = this.findEObjectIndexerFromEObject(identifier.getEObject());
        if (indexer != null) {
            result = this.propertySources.get(indexer);
        }
        return result;
    }

    private EObjectIndexer findEObjectIndexerFromEObject(EObject eObject) {
        EObjectIndexer result = null;
        Iterator<EObjectIndexer> iterEObjectIndexer = this.propertySources.keySet().iterator();
        while (iterEObjectIndexer.hasNext() && result == null) {
            EObjectIndexer currentIndexer = iterEObjectIndexer.next();
            if (!currentIndexer.getEObject().equals(eObject)) continue;
            result = currentIndexer;
        }
        return result;
    }

    protected Map<EObject, String> getCategoryNames() {
        return this.categoryNames;
    }

    private static final class DelegatingCompositePropertySource
    implements IPropertySource {
        private Set<IPropertySource> propertySources = new HashSet<IPropertySource>();

        private DelegatingCompositePropertySource() {
        }

        public void addPropertySource(IPropertySource propertySource) {
            this.propertySources.add(propertySource);
        }

        public Object getEditableValue() {
            return this.propertySources;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            LinkedList<IPropertyDescriptor> propertyDescriptors = new LinkedList<IPropertyDescriptor>();
            for (IPropertySource propertySource : this.propertySources) {
                propertyDescriptors.addAll(Arrays.asList(propertySource.getPropertyDescriptors()));
            }
            return propertyDescriptors.toArray(new IPropertyDescriptor[propertyDescriptors.size()]);
        }

        public Object getPropertyValue(Object id) {
            IPropertySource propertySource = this.getPropertySourceFor(id);
            if (propertySource != null) {
                return propertySource.getPropertyValue(id);
            }
            return null;
        }

        public boolean isPropertySet(Object id) {
            IPropertySource propertySource = this.getPropertySourceFor(id);
            if (propertySource != null) {
                return propertySource.isPropertySet(id);
            }
            return false;
        }

        public void resetPropertyValue(Object id) {
            IPropertySource propertySource = this.getPropertySourceFor(id);
            if (propertySource != null) {
                propertySource.resetPropertyValue(id);
            }
        }

        public void setPropertyValue(Object id, Object value) {
            IPropertySource propertySource = this.getPropertySourceFor(id);
            if (propertySource != null) {
                propertySource.setPropertyValue(id, value);
            }
        }

        private IPropertySource getPropertySourceFor(Object id) {
            IPropertySource result = null;
            Iterator<IPropertySource> iterPropertySources = this.propertySources.iterator();
            while (iterPropertySources.hasNext() && result == null) {
                IPropertySource propertySource = iterPropertySources.next();
                IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
                int i = 0;
                while (i < descriptors.length && result == null) {
                    if (descriptors[i].getId().equals(id)) {
                        result = propertySource;
                    }
                    ++i;
                }
            }
            return result;
        }
    }

    private static class EObjectIndexer
    implements Comparable {
        private int index;
        private EObject eObject;

        public EObjectIndexer(int index, EObject eObject) throws IllegalArgumentException {
            if (eObject == null) {
                throw new IllegalArgumentException();
            }
            this.index = index;
            this.eObject = eObject;
        }

        public int compareTo(Object o) {
            EObjectIndexer eObjectIndexer = (EObjectIndexer)o;
            return this.index - eObjectIndexer.index;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof EObjectIndexer) {
                EObjectIndexer eObjectIndexer = (EObjectIndexer)obj;
                result = this.index == eObjectIndexer.index;
            }
            return result;
        }

        public EObject getEObject() {
            return this.eObject;
        }
    }

    protected static class Identifier {
        private EObject eObject;
        private Object id;

        public Identifier(EObject eObject, Object id) {
            if (eObject == null) {
                throw new IllegalArgumentException(Messages.AbstractCompositeEObjectPropertySource_missingEObject);
            }
            if (id == null) {
                throw new IllegalArgumentException(Messages.AbstractCompositeEObjectPropertySource_missingId);
            }
            this.eObject = eObject;
            this.id = id;
        }

        public EObject getEObject() {
            return this.eObject;
        }

        public Object getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Identifier) {
                Identifier identifier = (Identifier)obj;
                return this.eObject.equals(identifier.eObject) && this.id.equals(identifier.id);
            }
            return false;
        }

        public int hashCode() {
            return this.eObject.hashCode();
        }
    }

    private static class PropertyDescriptorDecorator
    implements IPropertyDescriptor {
        private String category;
        private IPropertyDescriptor decorated;
        private Identifier identifier;

        public PropertyDescriptorDecorator(IPropertyDescriptor decorated, String category, EObject eObject) {
            this.category = category;
            this.decorated = decorated;
            this.identifier = new Identifier(eObject, this.decorated.getId());
        }

        public CellEditor createPropertyEditor(Composite parent) {
            CellEditor cellEditor = null;
            if (this.getPermissionAuthority().canEditInstance(this.identifier.getEObject())) {
                cellEditor = this.decorated.createPropertyEditor(parent);
            }
            return cellEditor;
        }

        private IPermissionAuthority getPermissionAuthority() {
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(this.identifier.getEObject());
            return accessor.getPermissionAuthority();
        }

        public String getCategory() {
            return this.category;
        }

        public String getDescription() {
            return this.decorated.getDescription();
        }

        public String getDisplayName() {
            return this.decorated.getDisplayName();
        }

        public String[] getFilterFlags() {
            return this.decorated.getFilterFlags();
        }

        public Object getHelpContextIds() {
            return this.decorated.getHelpContextIds();
        }

        public Object getId() {
            return this.identifier;
        }

        public ILabelProvider getLabelProvider() {
            return this.decorated.getLabelProvider();
        }

        public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
            return this.decorated.isCompatibleWith(anotherProperty);
        }
    }
}

