/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.dialect.command.MoveRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.tools.internal.command.PrepareNewAnalysisCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SessionResourceCreationWizardPage;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExtractRepresentationsWizard
extends Wizard {
    private final TransactionalEditingDomain domain;
    private Session session;
    private Collection<DRepresentationDescriptor> repDescriptors;
    private SessionResourceCreationWizardPage sessionResourceFilePage;
    private Resource pickedResource;

    public ExtractRepresentationsWizard(Session session, TransactionalEditingDomain domain, Collection<DRepresentationDescriptor> movableRepDescriptors) {
        this.domain = domain;
        this.session = session;
        this.repDescriptors = movableRepDescriptors;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ExtractRepresentationsWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.closeRepresentations();
        DiagramFileCreationOperation op = new DiagramFileCreationOperation();
        boolean errorCatch = false;
        errorCatch = this.createAIRDFile((IRunnableWithProgress)op, errorCatch);
        if (errorCatch) {
            return false;
        }
        DAnalysis slaveAnalysis = this.prepareNewAnalysis();
        this.moveRepresentations(slaveAnalysis);
        return true;
    }

    private void moveRepresentations(final DAnalysis slaveAnalysis) {
        IRunnableWithProgress moveReps = new IRunnableWithProgress(){

            public void run(IProgressMonitor mon) {
                ExtractRepresentationsWizard.this.domain.getCommandStack().execute((Command)new MoveRepresentationCommand(ExtractRepresentationsWizard.this.session, slaveAnalysis, ExtractRepresentationsWizard.this.repDescriptors));
            }
        };
        try {
            this.getContainer().run(false, true, moveReps);
        }
        catch (InterruptedException e) {
            SiriusPlugin.getDefault().warning(Messages.ExtractRepresentationsWizard_moveInterrupted, (Exception)e);
        }
        catch (InvocationTargetException e) {
            SiriusPlugin.getDefault().error(Messages.ExtractRepresentationsWizard_moveFailed, (Throwable)e);
        }
    }

    private boolean createAIRDFile(IRunnableWithProgress op, boolean error) {
        boolean errorCatch = error;
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InterruptedException interruptedException) {
            errorCatch = true;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.ExtractRepresentationsWizard_resourceCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                SiriusTransPlugin.getPlugin().error(Messages.ExtractRepresentationsWizard_airdCreationError, e.getTargetException());
            }
            errorCatch = true;
        }
        return errorCatch;
    }

    private DAnalysis prepareNewAnalysis() {
        DAnalysis slaveAnalysis = ViewpointFactory.eINSTANCE.createDAnalysis();
        this.domain.getCommandStack().execute((Command)new PrepareNewAnalysisCommand(this.domain, this.pickedResource, slaveAnalysis, this.session));
        return slaveAnalysis;
    }

    private void closeRepresentations() {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(this.session);
        if (uiSession != null) {
            for (DRepresentationDescriptor repDescriptor : this.repDescriptors) {
                this.closeOpenedEditor(uiSession, repDescriptor.getRepresentation());
            }
        }
    }

    private void closeOpenedEditor(IEditingSession uiSession, DRepresentation representation) {
        DialectEditor editor = uiSession.getEditor(representation);
        if (editor != null) {
            editor.getEditorSite().getPage().closeEditor((IEditorPart)editor, false);
        }
    }

    public void addPages() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("odesign");
        this.sessionResourceFilePage = new SessionResourceCreationWizardPage(Messages.ExtractRepresentationsWizard_pageName, (IStructuredSelection)new StructuredSelection(), "aird");
        this.addPage((IWizardPage)this.sessionResourceFilePage);
    }

    public Resource getCreatedResource() {
        return this.pickedResource;
    }

    private class DiagramFileCreationOperation
    extends WorkspaceModifyOperation {
        public DiagramFileCreationOperation() {
            super(null);
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
            ResourceSet set = ExtractRepresentationsWizard.this.session.getTransactionalEditingDomain().getResourceSet();
            ExtractRepresentationsWizard.this.pickedResource = set.createResource(ExtractRepresentationsWizard.this.sessionResourceFilePage.getURI());
        }
    }
}

