/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.kitalpha.emde.extension.DefaultModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.ExtendedModel;
import org.polarsys.kitalpha.emde.extension.ExtensibleModel;
import org.polarsys.kitalpha.emde.extension.ExtensionManagerDelegate;
import org.polarsys.kitalpha.emde.extension.ModelExtensionListener;
import org.polarsys.kitalpha.emde.extension.ModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.ModelExtensionOverallListener;
import org.polarsys.kitalpha.emde.extension.preferences.PreferenceModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class ModelExtensionHelper {
    private static final ModelExtensionManager nullManager = new NullModelExtensionManager();
    private static final Map<Object, ModelExtensionManager> instances = new HashMap<Object, ModelExtensionManager>();

    public static ModelExtensionManager getInstance(Resource resource) {
        return ModelExtensionHelper.getInstance(resource.getResourceSet());
    }

    public static ModelExtensionManager getInstance(final ResourceSet ctx) {
        if (ctx == null) {
            return nullManager;
        }
        ModelExtensionManager instance = instances.get(ctx);
        if (instance == null) {
            instance = ModelExtensionHelper.createInstance();
            instances.put(ctx, instance);
            ((DefaultModelExtensionManager)instance).setTarget(ctx);
            ctx.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() == 4 && ctx.getResources().isEmpty()) {
                        instances.remove(ctx);
                    }
                }
            });
        }
        return instance;
    }

    public static ModelExtensionManager getInstance(EObject ctx) {
        if (ctx == null || ctx.eResource() == null) {
            return nullManager;
        }
        return ModelExtensionHelper.getInstance(ctx.eResource());
    }

    private static ModelExtensionManager createInstance() {
        try {
            IConfigurationElement[] elts = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.emde.extension.model.manager");
            if (elts.length == 0) {
                return new PreferenceModelExtensionManager();
            }
            if (elts.length == 1) {
                return ModelExtensionHelper.configure((ModelExtensionManager)elts[0].createExecutableExtension("class"));
            }
            if (elts.length > 1) {
                Log.getDefault().logWarning("Got " + elts.length + " implementations for PE 'org.polarsys.kitalpha.emde.extension.model.manager'");
            }
            return ModelExtensionHelper.configure((ModelExtensionManager)elts[0].createExecutableExtension("class"));
        }
        catch (CoreException e) {
            Log.getDefault().logError((Throwable)e);
            return new PreferenceModelExtensionManager();
        }
    }

    private static ModelExtensionManager configure(ModelExtensionManager mgr) throws CoreException {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.emde.extension.model.manager.delegate");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            ExtensionManagerDelegate delegate = (ExtensionManagerDelegate)elt.createExecutableExtension("class");
            mgr.getDelegates().add(delegate);
            ++n2;
        }
        return mgr;
    }

    public static void addOverallListener(ModelExtensionOverallListener l) {
        DefaultModelExtensionManager.addOverallListener(l);
    }

    public static void removeOverallListener(ModelExtensionOverallListener l) {
        DefaultModelExtensionManager.removeOverallListener(l);
    }

    private static class NullModelExtensionManager
    implements ModelExtensionManager {
        private NullModelExtensionManager() {
        }

        @Override
        public boolean isExtensionModelDisabled(String extensibleModel, String extendedModel) {
            return false;
        }

        @Override
        public boolean canDisableExtensionModel(ExtendedModel extended) {
            return false;
        }

        @Override
        public boolean isExtensionModelDisabled(ExtendedModel extended) {
            return false;
        }

        @Override
        public boolean isExtensionModelDisabled(Object object) {
            return false;
        }

        @Override
        public boolean isExtensionModelDisabled(EObject eObject) {
            return false;
        }

        @Override
        public void setExtensionModelDisabled(ExtensibleModel extensibleModel, ExtendedModel extendedModel, boolean disabled) {
        }

        @Override
        public List<ExtensionManagerDelegate> getDelegates() {
            return new ArrayList<ExtensionManagerDelegate>();
        }

        @Override
        public void addListener(ModelExtensionListener l) {
        }

        @Override
        public void removeListener(ModelExtensionListener l) {
        }
    }
}

