/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketConnectionQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.part.specific.BracketEdgeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAccordingToDraw2DCommand;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SetConnectionBendpointsAccordingToExtremityMoveCommmand;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.SetLabelsOffsetCommmand;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class ChangeBendpointsOfEdgesCommand
extends AbstractTransactionalCommand {
    CompositeTransactionalCommand wrappedCommand;
    IGraphicalEditPart movedPart;
    PrecisionPoint moveDelta;
    boolean ignorePrimarySelection;
    boolean ignoreSelectionChecks;

    public ChangeBendpointsOfEdgesCommand(IGraphicalEditPart movedPart, PrecisionPoint moveDelta) {
        super(movedPart.getEditingDomain(), Messages.ChangeBendpointsOfEdgesCommand_label, null);
        this.movedPart = movedPart;
        this.moveDelta = moveDelta;
    }

    public ChangeBendpointsOfEdgesCommand(IGraphicalEditPart movedPart, PrecisionPoint moveDelta, boolean ignorePrimarySelection) {
        this(movedPart, moveDelta);
        this.ignorePrimarySelection = ignorePrimarySelection;
    }

    public boolean isSelectionChecksIgnored() {
        return this.ignoreSelectionChecks;
    }

    public void setIgnoreSelectionChecks(boolean ignoreSelectionChecks) {
        this.ignoreSelectionChecks = ignoreSelectionChecks;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
        CommandResult result = CommandResult.newOKCommandResult();
        if (!this.ignorePrimarySelection || this.movedPart.getSelected() != 2) {
            List selectedEditParts = this.movedPart.getViewer().getSelectedEditParts();
            if (this.movedPart instanceof AbstractGraphicalEditPart) {
                List<AbstractGraphicalEditPart> allMovedEditParts = this.getMovedChildren(Iterables.filter((Iterable)selectedEditParts, AbstractGraphicalEditPart.class), true);
                if (selectedEditParts.contains(this.movedPart) || allMovedEditParts.contains(this.movedPart) || this.isSelectionChecksIgnored()) {
                    AbstractGraphicalEditPart currentMovedEditPart = (AbstractGraphicalEditPart)this.movedPart;
                    List<AbstractGraphicalEditPart> currentMovedEditPartAndItsChildren = this.getMovedChildren(currentMovedEditPart, true);
                    TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((Object)this.movedPart.getModel());
                    for (AbstractGraphicalEditPart movedEditPart : currentMovedEditPartAndItsChildren) {
                        this.completeCommandWithBendpointsChangedCommand(movedEditPart.getSourceConnections(), (Point)this.moveDelta, true, allMovedEditParts, transactionalEditingDomain);
                        this.completeCommandWithBendpointsChangedCommand(movedEditPart.getTargetConnections(), (Point)this.moveDelta, false, allMovedEditParts, transactionalEditingDomain);
                    }
                }
            }
        }
        if (this.wrappedCommand != null) {
            if (this.wrappedCommand.canExecute()) {
                try {
                    this.wrappedCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    result = CommandResult.newErrorCommandResult((Throwable)e);
                }
            } else {
                result = CommandResult.newWarningCommandResult((String)Messages.ChangeBendpointsOfEdgesCommand_warningCommandResultMessage, null);
            }
        }
        return result;
    }

    protected void completeCommandWithBendpointsChangedCommand(List<?> connectionEditParts, Point moveDelta, boolean sourceMove, List<AbstractGraphicalEditPart> allMovedEditParts, TransactionalEditingDomain transactionalEditingDomain) {
        for (ConnectionEditPart connectionEditPart : Iterables.filter(connectionEditParts, ConnectionEditPart.class)) {
            Option<CompositeTransactionalCommand> optionalCommand = this.getBendpointsChangedCommand(transactionalEditingDomain, moveDelta, connectionEditPart, allMovedEditParts, sourceMove);
            if (!optionalCommand.some()) continue;
            if (this.wrappedCommand == null) {
                this.wrappedCommand = (CompositeTransactionalCommand)optionalCommand.get();
                continue;
            }
            Iterator iterator = ((CompositeTransactionalCommand)optionalCommand.get()).iterator();
            while (iterator.hasNext()) {
                this.wrappedCommand.add((IUndoableOperation)iterator.next());
            }
        }
    }

    public boolean canUndo() {
        if (this.wrappedCommand != null) {
            return this.wrappedCommand.canUndo();
        }
        return true;
    }

    public boolean canRedo() {
        if (this.wrappedCommand != null) {
            return this.wrappedCommand.canRedo();
        }
        return true;
    }

    public void dispose() {
        this.movedPart = null;
        this.wrappedCommand = null;
    }

    protected Option<CompositeTransactionalCommand> getBendpointsChangedCommand(TransactionalEditingDomain transactionalEditingDomain, Point moveDelta, ConnectionEditPart connectionEditPart, List<AbstractGraphicalEditPart> allMovedEditParts, boolean sourceMove) {
        Option result = Options.newNone();
        if (connectionEditPart.getSource() != null && connectionEditPart.getTarget() != null) {
            Connection connectionFigure = connectionEditPart.getConnectionFigure();
            ConnectionEditPartQuery connectionEditPartQuery = new ConnectionEditPartQuery((org.eclipse.gef.ConnectionEditPart)connectionEditPart);
            if (new ConnectionQuery(connectionFigure).isOrthogonalTreeBranch(connectionFigure.getPoints()) && connectionEditPartQuery.isLayoutComponent()) {
                CompositeTransactionalCommand command = new CompositeTransactionalCommand(transactionalEditingDomain, Messages.ChangeBendpointsOfEdgesCommand_mapGmfToDraw2dCommandLabel);
                SetConnectionAnchorsCommand setConnectionAnchorsCommand = new SetConnectionAnchorsCommand(transactionalEditingDomain, Messages.ChangeBendpointsOfEdgesCommand_mapGmfAnchorToDraw2dAnchorCommandLabel);
                setConnectionAnchorsCommand.setEdgeAdaptor((IAdaptable)connectionEditPart);
                setConnectionAnchorsCommand.setNewSourceTerminal(((INodeEditPart)connectionEditPart.getSource()).mapConnectionAnchorToTerminal(connectionFigure.getSourceAnchor()));
                setConnectionAnchorsCommand.setNewTargetTerminal(((INodeEditPart)connectionEditPart.getTarget()).mapConnectionAnchorToTerminal(connectionFigure.getTargetAnchor()));
                command.add((IUndoableOperation)setConnectionAnchorsCommand);
                SetConnectionBendpointsAccordingToDraw2DCommand setConnectionBendpointsCommand = new SetConnectionBendpointsAccordingToDraw2DCommand(transactionalEditingDomain);
                setConnectionBendpointsCommand.setLabel(Messages.ChangeBendpointsOfEdgesCommand_mapGmfPointsToDraw2dPoints);
                setConnectionBendpointsCommand.setSourceMove(sourceMove);
                setConnectionBendpointsCommand.setMoveDelta(new PrecisionPoint(moveDelta));
                setConnectionBendpointsCommand.setEdgeAdapter((IAdaptable)connectionEditPart);
                setConnectionBendpointsCommand.setNewPointList(connectionEditPart);
                if (this.isBothSourceAndTargetMoved(connectionEditPart, allMovedEditParts, sourceMove)) {
                    setConnectionBendpointsCommand.setLabelsToUpdate(connectionEditPart);
                }
                command.add((IUndoableOperation)setConnectionBendpointsCommand);
                result = Options.newSome((Object)command);
            } else if (connectionEditPartQuery.isEdgeWithObliqueRoutingStyle() || connectionEditPartQuery.isEdgeWithRectilinearRoutingStyle()) {
                if (!allMovedEditParts.isEmpty() && this.isBothSourceAndTargetMoved(connectionEditPart, allMovedEditParts, sourceMove)) {
                    CompositeTransactionalCommand command = new CompositeTransactionalCommand(transactionalEditingDomain, Messages.ChangeBendpointsOfEdgesCommand_mapGmfToDraw2dCommandLabel);
                    SetConnectionAnchorsCommand setConnectionAnchorsCommand = new SetConnectionAnchorsCommand(transactionalEditingDomain, "");
                    setConnectionAnchorsCommand.setEdgeAdaptor((IAdaptable)connectionEditPart);
                    setConnectionAnchorsCommand.setNewSourceTerminal(((INodeEditPart)connectionEditPart.getSource()).mapConnectionAnchorToTerminal(connectionFigure.getSourceAnchor()));
                    setConnectionAnchorsCommand.setNewTargetTerminal(((INodeEditPart)connectionEditPart.getTarget()).mapConnectionAnchorToTerminal(connectionFigure.getTargetAnchor()));
                    command.add((IUndoableOperation)setConnectionAnchorsCommand);
                    SetConnectionBendpointsAccordingToExtremityMoveCommmand setConnectionBendpointsCommand = new SetConnectionBendpointsAccordingToExtremityMoveCommmand(transactionalEditingDomain);
                    setConnectionBendpointsCommand.setSourceMove(sourceMove);
                    setConnectionBendpointsCommand.setMoveDelta(new PrecisionPoint(moveDelta));
                    setConnectionBendpointsCommand.setEdgeAdapter((IAdaptable)connectionEditPart);
                    setConnectionBendpointsCommand.setLabelsToUpdate(connectionEditPart);
                    command.add((IUndoableOperation)setConnectionBendpointsCommand);
                    result = Options.newSome((Object)command);
                }
            } else if (connectionEditPart instanceof BracketEdgeEditPart && !allMovedEditParts.isEmpty() && this.isBothSourceAndTargetMoved(connectionEditPart, allMovedEditParts, sourceMove)) {
                CompositeTransactionalCommand command = new CompositeTransactionalCommand(transactionalEditingDomain, Messages.ChangeBendpointsOfEdgesCommand_updateLabelsOffsetCmdLabel);
                connectionEditPart.getConnectionFigure().getPoints();
                PointList futurePointList = new BracketConnectionQuery(connectionEditPart.getConnectionFigure()).getPointListFromConstraintAndMove(moveDelta, sourceMove);
                SetLabelsOffsetCommmand setLabelsOffsetCommand = new SetLabelsOffsetCommmand(transactionalEditingDomain);
                setLabelsOffsetCommand.setNewPointList(futurePointList);
                setLabelsOffsetCommand.setLabelsToUpdate(connectionEditPart);
                command.add((IUndoableOperation)setLabelsOffsetCommand);
                result = Options.newSome((Object)command);
            }
        }
        return result;
    }

    private boolean isBothSourceAndTargetMoved(ConnectionEditPart connectionEditPart, List<AbstractGraphicalEditPart> allMovedEditParts, boolean sourceMove) {
        return sourceMove && !allMovedEditParts.contains(connectionEditPart.getTarget()) || !sourceMove && !allMovedEditParts.contains(connectionEditPart.getSource());
    }

    private List<AbstractGraphicalEditPart> getMovedChildren(Iterable<AbstractGraphicalEditPart> parentEditParts, boolean addSelf) {
        ArrayList result = Lists.newArrayList();
        for (AbstractGraphicalEditPart abstractGraphicalEditPart : parentEditParts) {
            if (this.ignorePrimarySelection && abstractGraphicalEditPart.getSelected() == 2) continue;
            result.addAll(this.getMovedChildren(abstractGraphicalEditPart, true));
        }
        return result;
    }

    private List<AbstractGraphicalEditPart> getMovedChildren(AbstractGraphicalEditPart parentEditPart, boolean addSelf) {
        ArrayList result = Lists.newArrayList();
        if (addSelf) {
            result.add(parentEditPart);
        }
        result.addAll(this.getMovedChildren(Iterables.filter((Iterable)parentEditPart.getChildren(), AbstractGraphicalEditPart.class), true));
        return result;
    }
}

