/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.policies;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.part.Messages;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class OpenDiagramEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EditPart targetEditPart = this.getTargetEditPart(request);
        if (!(targetEditPart.getModel() instanceof View)) {
            return null;
        }
        View view = (View)targetEditPart.getModel();
        Style link = view.getStyle(NotationPackage.eINSTANCE.getHintedDiagramLinkStyle());
        if (!(link instanceof HintedDiagramLinkStyle)) {
            return null;
        }
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)view);
        return new ICommandProxy((ICommand)new OpenDiagramCommand(transactionalEditingDomain, (HintedDiagramLinkStyle)link));
    }

    private static class OpenDiagramCommand
    extends AbstractTransactionalCommand {
        private final HintedDiagramLinkStyle diagramFacet;

        OpenDiagramCommand(TransactionalEditingDomain transactionalEditingDomain, HintedDiagramLinkStyle linkStyle) {
            super(transactionalEditingDomain, Messages.CommandName_OpenDiagram, null);
            this.diagramFacet = linkStyle;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                Diagram diagram = this.getDiagramToOpen();
                if (diagram == null) {
                    diagram = this.intializeNewDiagram();
                }
                URI uri = EcoreUtil.getURI((EObject)diagram);
                EObject element = this.diagramFacet.getDiagramLink().getElement();
                if (element instanceof DDiagram) {
                    String editorName = ((DDiagram)element).getName();
                    URIEditorInput editorInput = new URIEditorInput(uri, editorName);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.openEditor((IEditorInput)editorInput, this.getEditorID());
                    return CommandResult.newOKCommandResult();
                }
                return CommandResult.newErrorCommandResult((String)org.eclipse.sirius.diagram.ui.provider.Messages.OpenDiagramCommand_notDiagramElementErrorMsg);
            }
            catch (Exception ex) {
                throw new ExecutionException(org.eclipse.sirius.diagram.ui.provider.Messages.OpenDiagramCommand_exceptionMsg, (Throwable)ex);
            }
        }

        protected Diagram getDiagramToOpen() {
            return this.diagramFacet.getDiagramLink();
        }

        protected Diagram intializeNewDiagram() throws ExecutionException {
            Diagram d = ViewService.createDiagram((EObject)this.getDiagramDomainElement(), (String)this.getDiagramKind(), (PreferencesHint)this.getPreferencesHint());
            if (d == null) {
                throw new ExecutionException(MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.OpenDiagramCommand_creationErrorMsg, this.getDiagramKind()));
            }
            this.diagramFacet.setDiagramLink(d);
            final Resource diagramFacetResource = this.diagramFacet.eResource();
            assert (diagramFacetResource != null);
            diagramFacetResource.getContents().add((Object)d);
            try {
                new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            for (Resource nextResource : diagramFacetResource.getResourceSet().getResources()) {
                                if (!nextResource.isLoaded() || OpenDiagramCommand.this.getEditingDomain().isReadOnly(nextResource)) continue;
                                nextResource.save(SiriusDiagramEditorUtil.getSaveOptions());
                            }
                        }
                        catch (IOException ex) {
                            throw new InvocationTargetException(ex, org.eclipse.sirius.diagram.ui.provider.Messages.OpenDiagramCommand_saveFailedMsg);
                        }
                    }
                }.run(null);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException(MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.OpenDiagramCommand_creationErrorMsg, this.getDiagramKind()), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ExecutionException(MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.OpenDiagramCommand_creationErrorMsg, this.getDiagramKind()), (Throwable)e);
            }
            return d;
        }

        protected EObject getDiagramDomainElement() {
            return ((View)this.diagramFacet.eContainer()).getElement();
        }

        protected PreferencesHint getPreferencesHint() {
            return DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT;
        }

        protected String getDiagramKind() {
            return "Sirius";
        }

        protected String getEditorID() {
            return "org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID";
        }
    }
}

