/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.detachment.ui.contrib.viewpoints.pages;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.ui.utilities.ExtensionTreeViewer;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.providers.ViewpointTreeLabelProvider;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.providers.ViewpointTreeProvider;
import org.polarsys.kitalpha.model.detachment.ui.contrib.viewpoints.Messages;
import org.polarsys.kitalpha.model.detachment.ui.page.AbstractDetachmentFormPage;

public class ViewpointsHierarchyPage
extends AbstractDetachmentFormPage {
    private ExtensionTreeViewer treeViewer;
    private Button selectAllButton;
    private Button deSelectAllButton;

    public ViewpointsHierarchyPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit tk = managedForm.getToolkit();
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(Messages.VIEWPOINTS_HIERARCHY);
        scrolledForm.setExpandHorizontal(true);
        Composite composite = scrolledForm.getBody();
        composite.setLayout((Layout)new FillLayout());
        Section section = tk.createSection(composite, 384);
        section.setText(Messages.VIEWPOINTS_HIERARCHY);
        section.setDescription(Messages.VIEWPOINTS_HIERARCHY_DESC);
        Composite sectionClient = tk.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().margins(10, 5).numColumns(1).applyTo(sectionClient);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sectionClient);
        GridLayoutFactory.fillDefaults().applyTo(sectionClient);
        this.treeViewer = new ExtensionTreeViewer(sectionClient, 2818);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.treeViewer.getControl());
        this.treeViewer.setContentProvider((IContentProvider)new ViewpointTreeProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ViewpointTreeLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator());
        this.createButtonGroup(sectionClient);
        section.setClient((Control)sectionClient);
        ModelScrutinyRegistry.RegistryElement regElt = null;
        try {
            regElt = Scrutineer.getRegistryElement((String)this.getFinderID());
        }
        catch (ModelScrutinyException e) {
            e.printStackTrace();
        }
        this.treeViewer.setInput(null);
        if (regElt != null) {
            for (IScrutinize next : regElt.getFinders()) {
                this.treeViewer.setInput(next.getAnalysisResult());
            }
            this.treeViewer.expandAll();
            this.treeViewer.setAllChecked(true);
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonGroup);
        this.selectAllButton = new Button(buttonGroup, 8);
        this.selectAllButton.setText(Messages.SELECT_ALL_LABEL);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewpointsHierarchyPage.this.treeViewer.allChecked(true);
            }
        });
        this.deSelectAllButton = new Button(buttonGroup, 8);
        this.deSelectAllButton.setText(Messages.DESELECT_ALL_LABEL);
        this.deSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewpointsHierarchyPage.this.treeViewer.allChecked(false);
            }
        });
    }
}

