/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amalgam.explorer.contextual.core.category.CategoryImpl;
import org.eclipse.amalgam.explorer.contextual.core.category.ICategory;
import org.eclipse.amalgam.explorer.contextual.core.model.IExplorerContextualModel;
import org.eclipse.amalgam.explorer.contextual.core.provider.wrapper.CategoryWrapper;
import org.eclipse.amalgam.explorer.contextual.core.provider.wrapper.EObjectWrapper;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.TreeItemListenerForHistory;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExplorerContextualTree
extends TreeViewer {
    protected IExplorerContextualModel model;
    protected String explorerID;

    public ExplorerContextualTree(Composite parent, IExplorerContextualModel model_p, String explorerID_p) {
        super(parent);
        this.explorerID = explorerID_p;
        this.model = model_p;
        this.updateAutoExpandLevel();
        this.getTree().addListener(17, (Listener)new TreeItemListenerForHistory(true, this.explorerID, this.model, this));
        this.getTree().addListener(18, (Listener)new TreeItemListenerForHistory(false, this.explorerID, this.model, this));
    }

    protected void updateAutoExpandLevel() {
        if (this.model.doesLimitateTreeExpansion()) {
            if (this.explorerID == "CurrentElementExplorer") {
                this.setAutoExpandLevel(3);
            } else {
                this.setAutoExpandLevel(2);
            }
        } else {
            this.setAutoExpandLevel(-1);
        }
    }

    protected Item[] getSelection(Control widget) {
        TreeItem[] itemlList;
        TreeItem[] treeItemArray = itemlList = ((Tree)widget).getSelection();
        int n = itemlList.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof EObjectWrapper) {
                EObjectWrapper wrapper = (EObjectWrapper)data;
                item.setData(wrapper.getElement());
            }
            ++n2;
        }
        return itemlList;
    }

    protected ColumnViewerEditor createViewerEditor() {
        return null;
    }

    protected void initializeHistory() {
        this.model.getOrCreateHistory(this.explorerID);
        for (TreeItem treeItem : this.getAllItems()) {
            Object data;
            if (this.getExpanded((Item)treeItem) || (data = treeItem.getData()) == null || !(data instanceof CategoryWrapper)) continue;
            CategoryImpl category = (CategoryImpl)((CategoryWrapper)data).getElement();
            this.model.saveExpandedState(category, this.explorerID, false);
        }
    }

    protected void restoreExpansionState(Object input) {
        TreeItem topItem = this.getTree().getTopItem();
        for (TreeItem treeItem : this.getAllItems()) {
            Object data = treeItem.getData();
            if (data == null || !this.model.doesLimitateTreeExpansion()) continue;
            if (data instanceof CategoryWrapper) {
                CategoryImpl category = (CategoryImpl)((CategoryWrapper)data).getElement();
                boolean expanded = this.model.getExpandedState((ICategory)category, this.explorerID);
                treeItem.setExpanded(expanded);
                continue;
            }
            if (this.explorerID == "CurrentElementExplorer" && treeItem == topItem) {
                treeItem.setExpanded(true);
                continue;
            }
            treeItem.setExpanded(false);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.updateAutoExpandLevel();
        if (oldInput != null && !this.model.containsExpandedHistory(this.explorerID)) {
            this.initializeHistory();
        }
        super.inputChanged(input, oldInput);
        if (input != null && this.model.containsExpandedHistory(this.explorerID)) {
            this.restoreExpansionState(input);
        }
    }

    private List<TreeItem> getAllItems() {
        ArrayList<TreeItem> allItems = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() != null) {
                allItems.add(item);
                this.getAllItems(item, allItems);
            }
            ++n2;
        }
        return allItems;
    }

    private void getAllItems(TreeItem currentItem, List<TreeItem> allItems) {
        TreeItem[] treeItemArray = currentItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem element = treeItemArray[n2];
            if (element.getData() != null) {
                allItems.add(element);
                this.getAllItems(element, allItems);
            }
            ++n2;
        }
    }
}

