/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.outline;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.AcceleoOutlinePageItemProviderAdapterFactory;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.AcceleoOutlinePageLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.QuickOutlineContentProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.QuickOutlinePatternFilter;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.Macro;
import org.eclipse.acceleo.parser.cst.Query;
import org.eclipse.acceleo.parser.cst.Template;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class QuickOutlineControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    protected final AcceleoEditor editor;
    private AdapterFactory adapterFactory;
    private FilteredTree filteredTree;
    private TreeViewer treeViewer;

    public QuickOutlineControl(Shell parentShell, int shellStyle, AcceleoEditor acceleoEditor) {
        super(parentShell, shellStyle, true, true, false, true, true, null, null);
        this.create();
        this.editor = acceleoEditor;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public final void dispose() {
        this.filteredTree.dispose();
        this.close();
    }

    public boolean hasContents() {
        return true;
    }

    public boolean isFocusControl() {
        return this.getShell() == Display.getCurrent().getActiveShell();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.filteredTree.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation()) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this.adapterFactory = null;
        this.filteredTree = null;
        this.treeViewer = null;
    }

    protected Control createDialogArea(Composite parent) {
        this.createTreeViewer(parent);
        this.addDisposeListener(this);
        return this.treeViewer.getControl();
    }

    protected void createTreeViewer(Composite parent) {
        this.createFilteredTree(parent);
        this.treeViewer = this.filteredTree.getViewer();
        final Tree tree = this.treeViewer.getTree();
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r' || event.character == '\u1000050') {
                    TreeItem[] selection = tree.getSelection();
                    if (selection[0].getData() instanceof CSTNode) {
                        CSTNode node = (CSTNode)selection[0].getData();
                        QuickOutlineControl.this.editor.selectRange(node.getStartPosition(), node.getEndPosition());
                        QuickOutlineControl.this.dispose();
                    }
                } else if (event.character == '\u001b') {
                    QuickOutlineControl.this.dispose();
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (tree.equals(event.getSource())) {
                    if (tree.getSelectionCount() != 1 || event.button != 1) {
                        return;
                    }
                    TreeItem[] selection = tree.getSelection();
                    if (selection[0].getData() instanceof CSTNode) {
                        CSTNode node = (CSTNode)selection[0].getData();
                        QuickOutlineControl.this.editor.selectRange(node.getStartPosition(), node.getEndPosition());
                        QuickOutlineControl.this.dispose();
                    }
                }
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new QuickOutlineContentProvider(this.getAdapterFactory()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AcceleoOutlinePageLabelProvider(this.getAdapterFactory()));
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof Template || element instanceof Query || element instanceof Macro;
            }
        });
    }

    private void createFilteredTree(Composite parent) {
        Constructor filteredTreeConstructor = null;
        try {
            filteredTreeConstructor = FilteredTree.class.getConstructor(Composite.class, Integer.TYPE, PatternFilter.class, Boolean.TYPE);
            this.filteredTree = (FilteredTree)filteredTreeConstructor.newInstance(new Object[]{parent, 772, new QuickOutlinePatternFilter(), Boolean.TRUE});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                filteredTreeConstructor = FilteredTree.class.getConstructor(Composite.class, Integer.TYPE, PatternFilter.class);
                this.filteredTree = (FilteredTree)filteredTreeConstructor.newInstance(new Object[]{parent, 772, new QuickOutlinePatternFilter()});
            }
            catch (NoSuchMethodException ee) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", ee.getMessage()));
            }
            catch (IllegalArgumentException ee) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", ee.getMessage()));
            }
            catch (InstantiationException ee) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", ee.getMessage()));
            }
            catch (IllegalAccessException ee) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", ee.getMessage()));
            }
            catch (InvocationTargetException ee) {
                AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", ee.getMessage()));
            }
        }
        catch (IllegalArgumentException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage()));
        }
        catch (InstantiationException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage()));
        }
        catch (IllegalAccessException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage()));
        }
        catch (InvocationTargetException e) {
            AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage()));
        }
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            ArrayList<ReflectiveItemProviderAdapterFactory> factories = new ArrayList<ReflectiveItemProviderAdapterFactory>();
            factories.add(new AcceleoOutlinePageItemProviderAdapterFactory());
            factories.add((ReflectiveItemProviderAdapterFactory)new ResourceItemProviderAdapterFactory());
            factories.add((ReflectiveItemProviderAdapterFactory)new EcoreItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());
            this.adapterFactory = new ComposedAdapterFactory(factories);
        }
        return this.adapterFactory;
    }

    protected boolean hasTitleArea() {
        return false;
    }
}

