/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.rules;

import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class OverrideNameRule
implements ISequenceRule {
    private final IToken token;

    public OverrideNameRule(IToken token) {
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    public int read(ICharacterScanner scanner) {
        int column = scanner.getColumn();
        if (!this.validateLocation(scanner)) {
            return 0;
        }
        assert (scanner.getColumn() == column);
        int shift = 0;
        int c = scanner.read();
        ++shift;
        while (c != -1 && (c == 58 || Character.isJavaIdentifierPart(c))) {
            c = scanner.read();
            ++shift;
        }
        scanner.unread();
        return --shift;
    }

    private boolean validateLocation(ICharacterScanner scanner) {
        boolean valid = true;
        int shift = 0;
        int n = this.unreadOverrides(scanner);
        valid = (shift += n) < 0;
        while (shift < 0) {
            scanner.read();
            ++shift;
        }
        return valid;
    }

    private int unreadOverrides(ICharacterScanner scanner) {
        int c;
        int shift = 0;
        do {
            c = this.unreadChar(scanner);
            --shift;
        } while (Character.isWhitespace(c));
        String word = "";
        while (c != -1 && Character.isJavaIdentifierPart(c)) {
            word = String.valueOf(Character.toString((char)c)) + word;
            c = this.unreadChar(scanner);
            --shift;
        }
        if (!"overrides".equals(word)) {
            while (shift < 0) {
                scanner.read();
                ++shift;
            }
        }
        return shift;
    }

    private int unreadChar(ICharacterScanner scanner) {
        scanner.unread();
        int c = scanner.read();
        scanner.unread();
        return c;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }
}

