/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.scrutiny.analyzer;

import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.kitalpha.model.common.scrutiny.Messages;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.scrutiny.visitor.ScrutinizeVisitor;

public class Scrutineer {
    private static Logger LOGGER = Logger.getLogger(Scrutineer.class);

    public static void startScrutiny(Collection<Resource> resources) {
        ScrutinizeVisitor visitor = new ScrutinizeVisitor();
        for (Resource resource : resources) {
            visitor.accept(resource);
        }
    }

    public static void startScrutiny(Resource resource) {
        ScrutinizeVisitor visitor = new ScrutinizeVisitor();
        visitor.accept(resource);
    }

    public static ModelScrutinyRegistry.RegistryElement getRegistryElement(String id) throws ModelScrutinyException {
        if (Scrutineer.isKnownScrutinizeId(id)) {
            return ModelScrutinyRegistry.INSTANCE.getRegistryElement(id);
        }
        String message = Messages.NO_SUCH_REGISTRY_ELEMENT;
        message = String.valueOf(message) + ": " + id;
        ModelScrutinyException e = new ModelScrutinyException(message);
        LOGGER.error((Object)message, (Throwable)e);
        throw e;
    }

    public static Collection<ModelScrutinyRegistry.RegistryElement> getAllRegistryElement() {
        return ModelScrutinyRegistry.INSTANCE.getRegistry().values();
    }

    public static Set<String> getAllScrutinizeId() {
        return ModelScrutinyRegistry.INSTANCE.getRegistry().keySet();
    }

    public static boolean isKnownScrutinizeId(String id) {
        return Scrutineer.getAllScrutinizeId().contains(id);
    }
}

