/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.sirius.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusUtil;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.InstancePanelDialog;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.AbstractInstanceExplorerView;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusInstanceExplorerView
extends AbstractInstanceExplorerView {
    public static String ID = "org.eclipse.emf.diffmerge.patterns.ui.sirius.views.siriusinstanceexplorerview";
    protected final List<Object> _graphicalContext = new FOrderedSet();
    protected Map<Session, ClosingSessionListener> _monitoredSessions = new HashMap<Session, ClosingSessionListener>(1);

    public static String getID() {
        return ID;
    }

    private TreeSelection buildSelectionTo(Object object_p) {
        if (object_p == null) {
            return new TreeSelection();
        }
        Set<Object> elements = object_p instanceof Collection ? (Set<Object>)object_p : Collections.singleton(object_p);
        ArrayList<LinkedList<Object>> paths = new ArrayList<LinkedList<Object>>();
        for (Object e : elements) {
            LinkedList<Object> start = new LinkedList<Object>();
            start.add(e);
            List<LinkedList<Object>> localPaths = this.buildSelectionRec(start);
            paths.addAll(localPaths);
        }
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(paths.size());
        for (List list : paths) {
            arrayList.add(new TreePath(list.toArray()));
        }
        return new TreeSelection(arrayList.toArray(new TreePath[arrayList.size()]));
    }

    private List<LinkedList<Object>> buildSelectionRec(LinkedList<Object> path_p) {
        ArrayList<LinkedList<Object>> result = new ArrayList<LinkedList<Object>>();
        List<Object> parents = this.buildSelectionParents(path_p.getFirst());
        if (parents.isEmpty()) {
            result.add(path_p);
        } else {
            for (Object parent : parents) {
                LinkedList<Object> extendedPath = new LinkedList<Object>(path_p);
                extendedPath.addFirst(parent);
                result.addAll(this.buildSelectionRec(extendedPath));
            }
        }
        return result;
    }

    private List<Object> buildSelectionParents(Object object_p) {
        List<Object> result = Collections.emptyList();
        Object parent = this.getContentProvider().getParent(object_p);
        if (parent != null) {
            result = Collections.singletonList(parent);
        } else if (object_p instanceof EObject) {
            Collection instances = SiriusInstanceExplorerView.getAllRelatedInstances((EObject)((EObject)object_p));
            result = Collections.unmodifiableList(new ArrayList(instances));
        }
        return result;
    }

    public void clean() {
        this._graphicalContext.clear();
        this._initialSelection.clear();
        this._instanceList.clear();
        this._referenceElement = null;
        this._contextElement = null;
    }

    protected DDiagram getCurrentDiagram() {
        DDiagramEditor diagramEditor;
        DRepresentation representation;
        IEditorPart editorPart;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        DDiagram result = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.isClosing() && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (editorPart = page.getActiveEditor()) instanceof DDiagramEditor && (representation = (diagramEditor = (DDiagramEditor)editorPart).getRepresentation()) instanceof DDiagram) {
            result = (DDiagram)representation;
        }
        return result;
    }

    protected void manageSelectedInstances() {
        List instances = this.getSelectionAsInstances();
        if (!instances.isEmpty()) {
            DDiagram diagram = this.getCurrentDiagram();
            InstancePanelDialog dialog = new InstancePanelDialog(this.getShell(), this._referenceElement, instances, (Object)diagram, this._graphicalContext);
            dialog.open();
        }
    }

    public void dispose() {
        for (Map.Entry<Session, ClosingSessionListener> entry : this._monitoredSessions.entrySet()) {
            entry.getKey().removeListener((SessionListener)entry.getValue());
        }
        this._monitoredSessions.clear();
        this.clean();
        super.dispose();
    }

    private DDiagram getDiagramFor(Object object_p) {
        EObject viewpointElement = SiriusLayersUtil.getViewpointElement((Object)object_p);
        return SiriusUtil.getDiagram((EObject)viewpointElement);
    }

    protected void monitorSessionClosingEvent(EObject element_p) {
        Session session = SessionManager.INSTANCE.getSession(element_p);
        if (session != null && !this._monitoredSessions.containsKey(session)) {
            ClosingSessionListener listener = new ClosingSessionListener(session);
            session.addListener((SessionListener)listener);
            this._monitoredSessions.put(session, listener);
        }
    }

    public void setInput(ISelection selection_p) {
        Collection<Object> instances = Collections.emptySet();
        EObject referenceElement = null;
        DDiagram diagram = null;
        FOrderedSet initialSelection = new FOrderedSet();
        FOrderedSet graphicalContext = new FOrderedSet();
        if (selection_p instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection_p).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object current;
                Collection localSelection;
                Object selected = objectArray[n2];
                if (diagram == null) {
                    diagram = this.getDiagramFor(selected);
                }
                if (selected instanceof IGraphicalEditPart) {
                    graphicalContext.add((IGraphicalEditPart)selected);
                }
                if (selected instanceof IPatternInstance) {
                    initialSelection.add((IPatternInstance)selected);
                }
                if (referenceElement == null && !(localSelection = this.toActualSelection(selected)).isEmpty() && (current = localSelection.iterator().next()) instanceof EObject) {
                    referenceElement = (EObject)current;
                }
                ++n2;
            }
            if (referenceElement != null) {
                instances = SiriusInstanceExplorerView.getAllInstances(referenceElement);
            }
        }
        this.setInput(instances, (Collection<? extends IPatternInstance>)initialSelection, referenceElement, (List<? extends IGraphicalEditPart>)graphicalContext);
    }

    public void setInput(Collection<? extends IPatternInstance> instances_p, Collection<? extends IPatternInstance> initialSelection_p, EObject referenceElement_p, List<? extends IGraphicalEditPart> graphicalContext_p) {
        TreeSelection newSelection;
        this.clean();
        this._instanceList.addAll(instances_p);
        this._initialSelection.addAll(initialSelection_p);
        this._referenceElement = referenceElement_p;
        this._graphicalContext.addAll(graphicalContext_p);
        this._viewer.setInput((Object)this._instanceList);
        EObject sessionElement = this._referenceElement;
        if (sessionElement == null && !this._instanceList.isEmpty() && this._instanceList.get(0) instanceof EObject) {
            sessionElement = (EObject)this._instanceList.get(0);
        }
        if (sessionElement != null) {
            this.monitorSessionClosingEvent(sessionElement);
        }
        this.registerContext(sessionElement);
        this.updateHeader();
        List forSelection = this._initialSelection;
        if (this._initialSelection.isEmpty()) {
            forSelection = this._referenceElement;
        }
        if ((newSelection = this.buildSelectionTo(forSelection)).isEmpty()) {
            this._viewer.collapseAll();
        } else {
            boolean singleSelection = newSelection.getPaths().length == 1;
            this._viewer.getTree().setRedraw(false);
            this._viewer.expandAll();
            if (singleSelection) {
                this._viewer.collapseAll();
            }
            this._viewer.getTree().setRedraw(true);
            this._viewer.setSelection((ISelection)newSelection, singleSelection);
        }
    }

    private void registerContext(EObject context_p) {
        EObject root;
        this._contextElement = context_p == null ? null : (root = EcoreUtil.getRootContainer((EObject)context_p));
    }

    protected class ClosingSessionListener
    implements SessionListener {
        private final Session _monitoredSession;

        public ClosingSessionListener(Session session_p) {
            this._monitoredSession = session_p;
        }

        public Session getMonitoredSession() {
            return this._monitoredSession;
        }

        private void handleClosingSession(Session monitoredSession_p) {
            Session session;
            Object currentInput = SiriusInstanceExplorerView.this.getViewer().getInput();
            if (currentInput instanceof Collection && !((Collection)currentInput).isEmpty()) {
                currentInput = ((Collection)currentInput).iterator().next();
            }
            if (currentInput instanceof EObject && monitoredSession_p.equals(session = SessionManager.INSTANCE.getSession((EObject)currentInput))) {
                SiriusInstanceExplorerView.this.setInput(null);
            }
        }

        public void notify(int changeKind_p) {
            switch (changeKind_p) {
                case 8: {
                    this.handleClosingSession(this._monitoredSession);
                    break;
                }
            }
        }
    }
}

