/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.ocl.provider.generic;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.ocl.ecore.OCL;
import org.polarsys.kitalpha.validation.ocl.provider.generic.GenericOCLConstraintFactory;
import org.polarsys.kitalpha.validation.ocl.provider.generic.util.OCLConstraint;
import org.polarsys.kitalpha.validation.ocl.provider.generic.util.OCLConstraintDescriptor;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintFactory;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintProvider;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintProviderService;

public abstract class GenericOCLConstraintProvider
extends GenericConstraintProvider {
    private void addConstraintToGlobalConstraintCollection(OCLConstraintDescriptor currentConstraintDescriptor) {
        OCLConstraint cst = new OCLConstraint(currentConstraintDescriptor, OCL.newInstance());
        this.getConstraints().add(cst);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        config.getContributor().getClass().getClassLoader();
        String constraintProviderID = config.getDeclaringExtension().getUniqueIdentifier();
        if (constraintProviderID == null) {
            constraintProviderID = "OCLProvider@" + Long.toHexString(System.identityHashCode((Object)this));
        }
        GenericConstraintProviderService.getInstance().registerProvider(this);
        List<? extends AbstractConstraintDescriptor> descriptors = GenericConstraintProviderService.getInstance().getDescriptors(this);
        for (AbstractConstraintDescriptor abstractConstraintDescriptor : descriptors) {
            if (!(abstractConstraintDescriptor instanceof OCLConstraintDescriptor)) continue;
            this.addConstraintToGlobalConstraintCollection((OCLConstraintDescriptor)abstractConstraintDescriptor);
        }
    }

    public GenericConstraintFactory getConstraintFactory() {
        return new GenericOCLConstraintFactory(this);
    }
}

