/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.provider.generic;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.kitalpha.validation.AccuracyPlugin;
import org.polarsys.kitalpha.validation.provider.generic.GenericConstraintProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericConstraintFactory {
    private static final String CANCEL = "CANCEL";
    private static final String ERROR = "ERROR";
    private static final String WARNING = "WARNING";
    private static final String INFO = "INFO";
    private static final String NULL = "NULL";
    private static final String INVARIANT = "Invariant";
    private static final String CATEGORIES = "Categories";
    private static final String CODE = "Code";
    private static final String SEVERITY = "Severity";
    private static final String MESSAGE = "Message";
    private static final String NAME = "Name";
    private static final String COMMON_ROOT_CATEGORY = "CommonRootCategory";
    private static final String MANDATORY_REQUIREMENT = "mandatory.rules.list";
    private static final String KEY_SEPARATOR = ".";
    private ResourceBundle configurationFileResourceBundle;

    public GenericConstraintFactory(GenericConstraintProvider provider) {
        this.configurationFileResourceBundle = provider.getConfigurationFileResourceBundle();
    }

    public void associateConstaintToCategory(AbstractConstraintDescriptor currentConstraintDescriptor, Category category) {
        if (category != null) {
            category.addConstraint((IConstraintDescriptor)currentConstraintDescriptor);
        }
    }

    public void associateConstraintToCategories(AbstractConstraintDescriptor currentConstraintDescriptor, List<String> constraintCategories) {
        for (String categoryName : constraintCategories) {
            Category currentCategory = CategoryManager.getInstance().getCategory(categoryName);
            this.associateConstaintToCategory(currentConstraintDescriptor, currentCategory);
        }
    }

    public String getCommonConstraintCategory() {
        return this.getString(COMMON_ROOT_CATEGORY);
    }

    protected ConstraintSeverity toConstraintSeverity(String severity) {
        if (severity != null) {
            if (severity.equals(NULL)) {
                return ConstraintSeverity.NULL;
            }
            if (severity.equals(INFO)) {
                return ConstraintSeverity.INFO;
            }
            if (severity.equals(WARNING)) {
                return ConstraintSeverity.WARNING;
            }
            if (severity.equals(ERROR)) {
                return ConstraintSeverity.ERROR;
            }
            if (severity.equals(CANCEL)) {
                return ConstraintSeverity.CANCEL;
            }
        }
        return ConstraintSeverity.ERROR;
    }

    public abstract List<AbstractConstraintDescriptor> createConstraints();

    protected String createKey(String requirementId, String invariantId, String keyword) {
        StringBuilder builder = new StringBuilder(requirementId.length() + invariantId.length() + keyword.length() + INVARIANT.length() + KEY_SEPARATOR.length() * 3);
        builder.append(requirementId);
        builder.append(KEY_SEPARATOR);
        builder.append(INVARIANT);
        builder.append(KEY_SEPARATOR);
        builder.append(invariantId);
        builder.append(KEY_SEPARATOR);
        builder.append(keyword);
        return builder.toString();
    }

    public String getName(String requirementId, String invariantId) {
        return this.getString(this.createKey(requirementId, invariantId, NAME));
    }

    public String getMessage(String requirementId, String invariantId) {
        return this.getString(this.createKey(requirementId, invariantId, MESSAGE));
    }

    public String getSeverity(String requirementId, String invariantId) {
        return this.getString(this.createKey(requirementId, invariantId, SEVERITY));
    }

    public String getCode(String requirementId, String invariantId) {
        String codeStr = this.getString(this.createKey(requirementId, invariantId, CODE));
        return codeStr;
    }

    public List<String> getConstraintCategories(String requirementId, String invariantId) {
        String categoriesString = this.getString(this.createKey(requirementId, invariantId, CATEGORIES));
        ArrayList<String> categories = new ArrayList<String>();
        if (categoriesString != null) {
            String[] categoriesArray;
            String[] stringArray = categoriesArray = categoriesString.split(",");
            int n = categoriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                categories.add(string.trim());
                ++n2;
            }
        }
        return categories;
    }

    protected int toIntegerCode(String codeStr) {
        String codeStrTmp = codeStr.replaceAll("^(0+)", "").trim();
        int code = -1;
        try {
            code = Integer.parseInt(codeStrTmp, 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return code;
    }

    protected List<String> getMandatoryRequirements() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.containsKey(MANDATORY_REQUIREMENT)) {
            return result;
        }
        String mandatoryRequirements = this.getString(MANDATORY_REQUIREMENT);
        if (mandatoryRequirements != null) {
            String[] split;
            String[] stringArray = split = mandatoryRequirements.split(Pattern.quote(","));
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String requirement = stringArray[n2];
                result.add(requirement.trim());
                ++n2;
            }
        }
        return result;
    }

    private String getString(String key) {
        try {
            return this.configurationFileResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            AccuracyPlugin.getDefault().error("Error while accessing configuration file", e);
            return null;
        }
    }

    private boolean containsKey(String mandatoryRequirement) {
        Enumeration<String> keys = this.configurationFileResourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (mandatoryRequirement == null || !mandatoryRequirement.equals(key)) continue;
            return true;
        }
        return false;
    }
}

