/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.metadata.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.metadata.commands.MetadataCommand;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;
import org.polarsys.kitalpha.ad.metadata.metadata.MetadataFactory;

public class CreateMetadataResourceCommand
extends MetadataCommand {
    private URI uri;
    private ResourceSet resourceSet;

    public CreateMetadataResourceCommand(ResourceSet resourceSet, URI uri) {
        super("Create metadata resource");
        this.resourceSet = resourceSet;
        this.uri = uri;
    }

    public void execute() {
        try {
            try {
                this.resourceSet.getResource(this.uri, true);
            }
            catch (Exception exception) {
                Resource resource = this.resourceSet.getResource(this.uri, false);
                if (resource != null && resource.getContents().isEmpty()) {
                    resource.unload();
                    this.resourceSet.getResources().remove((Object)resource);
                    resource = null;
                }
                if (resource == null) {
                    Resource newResource = this.resourceSet.createResource(this.uri);
                    Metadata metadata = MetadataFactory.eINSTANCE.createMetadata();
                    metadata.setId(EcoreUtil.generateUUID());
                    this.resourceSet.getResources().add((Object)newResource);
                    newResource.getContents().add((Object)metadata);
                }
            }
        }
        finally {
            Resource resource = this.resourceSet.getResource(this.uri, false);
            if (resource != null && resource.getContents().isEmpty()) {
                resource.unload();
                this.resourceSet.getResources().remove((Object)resource);
                resource = null;
            }
            if (resource == null) {
                Resource newResource = this.resourceSet.createResource(this.uri);
                Metadata metadata = MetadataFactory.eINSTANCE.createMetadata();
                metadata.setId(EcoreUtil.generateUUID());
                this.resourceSet.getResources().add((Object)newResource);
                newResource.getContents().add((Object)metadata);
            }
        }
    }

    public Collection<?> getResult() {
        return Collections.singletonList(this.resourceSet.getResource(this.uri, false));
    }

    public Resource getMetadataResource() {
        Collection<?> results = this.getResult();
        if (!results.isEmpty()) {
            return (Resource)this.getResult().iterator().next();
        }
        return null;
    }

    public void undo() {
        Resource resource = this.resourceSet.getResource(this.uri, false);
        if (resource != null) {
            resource.unload();
            this.resourceSet.getResources().remove((Object)resource);
        }
    }
}

