/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.runtime;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElementSet;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ProjectUtils;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ResourceManager;

public class ViewpointManager
extends ResourceManager {
    private Viewpoint viewpoint;

    public ViewpointManager(Viewpoint viewpoint) {
        this.viewpoint = viewpoint;
    }

    @Override
    public Object getRootModel() {
        return this.viewpoint;
    }

    @Override
    public long getModelTimeStamp() {
        Resource resource = this.viewpoint.eResource();
        return resource.getTimeStamp();
    }

    @Override
    public void saveModel() {
        if (this.isReadOnly()) {
            return;
        }
        IProject project = ProjectUtils.getContainingProject((EObject)this.viewpoint);
        if (project != null && project.isOpen()) {
            try {
                Resource resource = this.viewpoint.eResource();
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                AD_Log.getDefault().logError("An error has occured.", (Throwable)e);
            }
            this.fireEvent();
        }
    }

    public static abstract class ElementHandler
    extends ResourceManager.AbstractElementHandler {
        protected ElementHandler(Viewpoint viewpoint, ResourceManager wsManager) {
            super(viewpoint, wsManager);
        }

        @Override
        public boolean isRemovable(ViewpointElement element) {
            if (this.getResourceManager().isReadOnly()) {
                return false;
            }
            ViewpointElementSet set = (ViewpointElementSet)element.eContainer();
            return set.eContainer() == this.getViewpoint();
        }
    }
}

