/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.ui.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.polarsys.kitalpha.cadence.core.api.CadenceRegistry;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CadenceHelper {
    private static Map<String, Map<String, String>> parseActivity(String activities) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        if (!activities.equals("")) {
            String[] paramTab;
            String activity = "";
            String[] stringArray = paramTab = activities.split(Pattern.quote(";"));
            int n = paramTab.length;
            int n2 = 0;
            while (n2 < n) {
                String string_p = stringArray[n2];
                String[] tab = string_p.split(Pattern.quote(":"), 2);
                HashMap<String, String> map = new HashMap<String, String>();
                activity = tab[0];
                if (tab.length > 1) {
                    String[] stringArray2 = tab[1].split(Pattern.quote(","));
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String k = stringArray2[n4];
                        String[] t = k.split(Pattern.quote("="));
                        String key = t[0];
                        String value = "";
                        if (t.length == 2) {
                            value = t[1];
                        }
                        map.put(key, value);
                        ++n4;
                    }
                }
                result.put(activity, map);
                ++n2;
            }
        }
        return result;
    }

    public static WorkflowActivityParameter getActivitiesFromLauchConfiguration(ILaunchConfiguration configuration, String workflowElt_id) {
        WorkflowActivityParameter result;
        block5: {
            result = new WorkflowActivityParameter();
            try {
                Map activityMap = configuration.getAttribute("paramActivities", new HashMap());
                if (activityMap.isEmpty()) break block5;
                String activities = (String)activityMap.get(workflowElt_id);
                Map<String, Map<String, String>> map = CadenceHelper.parseActivity(activities);
                for (String activityID : map.keySet()) {
                    Map<String, String> params = map.get(activityID);
                    ActivityParameters paramsMap = CadenceHelper.constructMapFromString(params, activityID);
                    if (paramsMap != null && paramsMap.getParametersID() != null && !paramsMap.getParametersID().isEmpty()) {
                        for (String parameterID : paramsMap.getParametersID()) {
                            result.addParameter(activityID, paramsMap.getParameter(parameterID));
                        }
                        continue;
                    }
                    result.addActivity(activityID);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static ActivityParameters constructMapFromString(Map<String, String> map, String id) {
        ActivityParameters result = null;
        IActivity activity = CadenceRegistry.getIActivityClassFromId((String)id);
        if (activity != null) {
            result = CadenceHelper.constructMapFromString(map, activity);
        }
        return result;
    }

    public static ActivityParameters constructMapFromString(Map<String, String> map, IActivity activity) {
        Collection params = activity.getParameters();
        ActivityParameters uiParam = new ActivityParameters();
        if (params != null && !params.isEmpty()) {
            for (DeclaredParameter parameter : params) {
                String stringValue = map.get(parameter.getName());
                parameter.setValue((Object)stringValue);
                uiParam.addParameter((GenericParameter)parameter);
            }
        }
        return uiParam;
    }
}

