/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.cadence.ui.internal.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.kitalpha.cadence.core.api.CadenceRegistry;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.cadence.ui.api.CadenceTab;
import org.polarsys.kitalpha.cadence.ui.api.dialog.ITableEditingListener;
import org.polarsys.kitalpha.cadence.ui.api.dialog.ParametersDialog;
import org.polarsys.kitalpha.cadence.ui.internal.CadenceListSelectionDialog;
import org.polarsys.kitalpha.cadence.ui.internal.widgets.ActivitiesWidget;
import org.polarsys.kitalpha.cadence.ui.internal.widgets.ParameterWidget;
import org.polarsys.kitalpha.cadence.ui.internal.widgets.parameters.ParameterManager;
import org.polarsys.kitalpha.cadence.ui.providers.CadenceContentProvider;
import org.polarsys.kitalpha.cadence.ui.providers.CadenceLabelProvider;
import org.polarsys.kitalpha.cadence.ui.providers.ColumnParametersLabelProvider;
import org.polarsys.kitalpha.cadence.ui.providers.ColumnValuesLabelProvider;
import org.polarsys.kitalpha.cadence.ui.providers.TableContentProvider;
import org.polarsys.kitalpha.cadence.ui.providers.TableEditingSupport;

public class CadenceItem {
    private ParametersDialog dialog;
    private final CadenceTab tab;
    private ListViewer viewer = null;
    private WorkflowActivityParameter _params = new WorkflowActivityParameter();
    private IConfigurationElement workflowElement = null;
    private List<IConfigurationElement> _temporyList = new LinkedList<IConfigurationElement>();
    private String _activityId = "";
    private CTabItem delegate;
    private final int CONFIGURABLE_ELEMENT = 0;
    private final int IDENTIFIER = 1;
    private final int IACTIVITY = 2;
    public static final String PARAMETER_SEPARATOR = ":";

    public CadenceItem(CTabFolder tabFolder, IConfigurationElement workflowElement, String workflow_id, String workflowElt_id, String workflowElt_name, String workflow_description, CadenceTab tab) {
        this.delegate = new CTabItem(tabFolder, 512, 0);
        this.delegate.setData((Object)this);
        String order = CadenceRegistry.getOrderNumber((IConfigurationElement)workflowElement);
        String name = order != null ? String.valueOf(workflowElt_name) + "(" + order + ")" : workflowElt_name;
        this.delegate.setText(name);
        this.tab = tab;
        this.workflowElement = workflowElement;
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        description.setData((Object)gd);
        description.setText(workflow_description);
        new Label(composite, 0);
        ActivitiesWidget widget1 = new ActivitiesWidget(composite);
        ParameterWidget widget2 = new ParameterWidget(composite);
        this.initTable(widget2, workflow_id, workflowElt_id);
        IConfigurationElement[] activities = CadenceRegistry.getActivitiesConfigList((String)workflow_id, (String)workflowElt_id);
        this.attachListeners(widget1, widget2, activities);
        this.delegate.setControl((Control)composite);
    }

    public CTabItem getDelegate() {
        return this.delegate;
    }

    private void initTable(ParameterWidget widget, final String workflow_id, final String workflowElt_id) {
        Button detail = widget.getDetails();
        detail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IActivity activitySelected = (IActivity)CadenceItem.this.elementSelected(2);
                if (activitySelected != null) {
                    ITableEditingListener listener = new ITableEditingListener(){

                        public void parameterValueChanged() {
                            CadenceItem.this.tab.update();
                        }
                    };
                    CadenceItem.this.dialog = new ParametersDialog(CadenceItem.this.tab.getShell(), new TableContentProvider(CadenceRegistry.getWorkflowElementParameters((String)workflow_id, (String)workflowElt_id)), new ColumnParametersLabelProvider(), new ColumnValuesLabelProvider(), new ParameterManager());
                    CadenceItem.this.dialog.create();
                    TableEditingSupport edit = new TableEditingSupport((ColumnViewer)CadenceItem.this.dialog.getViewer(), listener);
                    CadenceItem.this.dialog.setEditingSupport(edit);
                    if (CadenceItem.this._params.getActivityParameters(CadenceItem.this._activityId) != null) {
                        CadenceItem.this.dialog.setContainer((IActivity)CadenceItem.this.elementSelected(2));
                        CadenceItem.this.dialog.setInput(CadenceItem.this._params.getActivityParameters(CadenceItem.this._activityId));
                    }
                    CadenceItem.this.dialog.open();
                }
            }
        });
    }

    private void attachListeners(ActivitiesWidget widget, ParameterWidget param_widget, IConfigurationElement[] activities) {
        this.viewer = widget.getViewer();
        this.attachViewerListener(param_widget);
        Button b = widget.getAddButton();
        this.attachAddListener(b, activities);
        b = widget.getRemoveButton();
        this.attachRemoveListener(b);
        b = widget.getUpButton();
        this.attachUpListener(b);
        b = widget.getDownButton();
        this.attachDownListener(b);
    }

    private void attachViewerListener(final ParameterWidget widget) {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String description;
                Object object;
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    widget.setDescription("");
                }
                if ((object = selection.getFirstElement()) != null && (description = CadenceRegistry.getDescription((IConfigurationElement)((IConfigurationElement)object))) != null) {
                    widget.setDescription(description);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CadenceItem.this._activityId = (String)CadenceItem.this.elementSelected(1);
            }
        });
    }

    private void attachDownListener(Button b) {
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConfigurationElement insert = (IConfigurationElement)CadenceItem.this.elementSelected(0);
                int index = CadenceItem.this._temporyList.indexOf(insert);
                CadenceItem.this._temporyList.remove(insert);
                CadenceItem.this._temporyList.add(++index, insert);
                CadenceItem.this.viewer.setInput((Object)CadenceItem.this._temporyList);
                CadenceItem.this.tab.update();
                CadenceItem.this.viewer.refresh();
            }
        });
    }

    private void attachUpListener(Button b) {
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConfigurationElement insert = (IConfigurationElement)CadenceItem.this.elementSelected(0);
                int index = CadenceItem.this._temporyList.indexOf(insert);
                if (index > 0) {
                    --index;
                }
                CadenceItem.this._temporyList.remove(insert);
                CadenceItem.this._temporyList.add(index, insert);
                CadenceItem.this.viewer.setInput((Object)CadenceItem.this._temporyList);
                CadenceItem.this.tab.update();
                CadenceItem.this.viewer.refresh();
            }
        });
    }

    private void attachRemoveListener(Button b) {
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object remove = CadenceItem.this.elementSelected(0);
                CadenceItem.this._temporyList.remove(remove);
                CadenceItem.this._params.removeActivityParameters((String)CadenceItem.this.elementSelected(1));
                CadenceItem.this.viewer.setInput((Object)CadenceItem.this._temporyList);
                CadenceItem.this.tab.update();
                CadenceItem.this.viewer.refresh();
            }
        });
    }

    private void attachAddListener(Button b, final IConfigurationElement[] activities) {
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                Object[] objectArray = result = CadenceItem.this.handleActivitiesSelect(activities);
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    IActivity act;
                    IConfigurationElement conf;
                    Object o = objectArray[n2];
                    String actId = "";
                    if (o instanceof IConfigurationElement && (!"".equals(actId = CadenceRegistry.getIdentifier((IConfigurationElement)(conf = (IConfigurationElement)o))) || actId != null) && (act = CadenceRegistry.getIActivityClassFromId((String)actId)) != null) {
                        CadenceItem.this._temporyList.add(conf);
                        CadenceItem.this._params.addParameter(actId, act.getParameters());
                    }
                    ++n2;
                }
                CadenceItem.this.viewer.setInput((Object)CadenceItem.this._temporyList);
                CadenceItem.this.viewer.refresh();
            }
        });
    }

    public String getParameters() {
        String value = "";
        String result = "";
        for (IConfigurationElement act : this._temporyList) {
            String actId = CadenceRegistry.getIdentifier((IConfigurationElement)act);
            ActivityParameters actParam = this._params.getActivityParameters(actId);
            value = String.valueOf(actId) + PARAMETER_SEPARATOR;
            if (actParam == null) continue;
            for (GenericParameter p : actParam.getParameters()) {
                value = String.valueOf(value) + p.getName() + "=" + p.getValue() + ",";
            }
            value = String.valueOf(value.substring(0, value.length() - PARAMETER_SEPARATOR.length())) + ";";
            result = String.valueOf(result) + value;
        }
        return result;
    }

    protected Object elementSelected(int type) {
        IStructuredSelection selection;
        Object object;
        Object result = null;
        ISelection selected = this.viewer.getSelection();
        if (selected instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)selected).getFirstElement()) != null) {
            switch (type) {
                case 0: {
                    result = object;
                    break;
                }
                case 1: {
                    result = CadenceRegistry.getIdentifier((IConfigurationElement)((IConfigurationElement)object));
                    break;
                }
                case 2: {
                    result = CadenceRegistry.getIActivityClass((IConfigurationElement)((IConfigurationElement)object));
                    break;
                }
            }
        }
        return result;
    }

    public void setParameters(String params) {
        this._temporyList.clear();
        this._params = new WorkflowActivityParameter();
        if (!params.equals("")) {
            String[] paramTab;
            String[] stringArray = paramTab = params.split(Pattern.quote(";"));
            int n = paramTab.length;
            int n2 = 0;
            while (n2 < n) {
                String string_p = stringArray[n2];
                String[] tab = string_p.split(Pattern.quote(PARAMETER_SEPARATOR), 2);
                if (tab.length >= 1) {
                    String actId = tab[0];
                    ActivityParameters map = new ActivityParameters();
                    if (tab.length >= 2) {
                        String[] stringArray2 = tab[1].split(Pattern.quote(","));
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String k = stringArray2[n4];
                            String[] t = k.split(Pattern.quote("="));
                            String key = t[0];
                            String value = "";
                            if (t.length == 2) {
                                value = t[1];
                            }
                            map.addParameter(new GenericParameter(key, (Object)value, ""));
                            ++n4;
                        }
                    }
                    IConfigurationElement conf_ac = CadenceRegistry.getActivity((String)actId);
                    this._temporyList.add(conf_ac);
                    this._params.addParameter(actId, map);
                }
                ++n2;
            }
        }
        this.viewer.setSelection((ISelection)new StructuredSelection());
        this.viewer.setInput(this._temporyList);
    }

    private Object[] handleActivitiesSelect(IConfigurationElement[] activities) {
        ArrayList<IConfigurationElement> availableActivities = new ArrayList<IConfigurationElement>();
        Object[] resultSelection = null;
        Set selectedActivities = this._params.getActivitiesID();
        availableActivities.addAll(Arrays.asList(activities));
        IConfigurationElement[] iConfigurationElementArray = activities;
        int n = activities.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement conf = iConfigurationElementArray[n2];
            String actId = CadenceRegistry.getIdentifier((IConfigurationElement)conf);
            boolean isMultiple = CadenceRegistry.isMultiple((IConfigurationElement)conf);
            if (!"".equals(actId) && actId != null && selectedActivities.contains(actId) && !isMultiple) {
                availableActivities.remove(conf);
            }
            ++n2;
        }
        CadenceListSelectionDialog dialog = new CadenceListSelectionDialog(this.tab.getControl().getShell(), availableActivities.toArray(), new CadenceContentProvider(), new CadenceLabelProvider(), "Select activities");
        if (resultSelection != null) {
            dialog.setInitialSelections(resultSelection);
        }
        if (dialog.open() == 0) {
            resultSelection = dialog.getResult();
        }
        return resultSelection == null ? new Object[]{} : resultSelection;
    }

    public String getDescription() {
        return CadenceRegistry.getDescription((IConfigurationElement)this.workflowElement);
    }
}

