/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.api.configuration.ConfigurationFactory;
import org.polarsys.kitalpha.composer.api.profiles.ComposerProfile;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.wizards.GenericLaunchConfigurationWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchFromProfileAction
extends Action {
    private ComposerProfile profile;
    private List<Object> selection;

    public LaunchFromProfileAction(ComposerProfile profile, List<Object> selection) {
        super(profile.getName());
        this.profile = profile;
        this.selection = selection;
    }

    public void run() {
        super.run();
        try {
            WizardDialog wizardDialog;
            GenericLaunchConfigurationWizard wizard;
            CodeManagerConfiguration configuration = ConfigurationFactory.getInstance().create(this.profile);
            ArrayList<ResourceSet> resourceSets = new ArrayList<ResourceSet>();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            ArrayList<EObject> eObjects = new ArrayList<EObject>();
            this.manageSelection(resourceSets, resources, eObjects, this.selection);
            for (ResourceSet resourceSet : resourceSets) {
                configuration.setResourceSet(resourceSet);
                wizard = new GenericLaunchConfigurationWizard(configuration, this.profile);
                wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                wizardDialog.open();
            }
            for (Resource resource : resources) {
                configuration.setResource(resource);
                wizard = new GenericLaunchConfigurationWizard(configuration, this.profile);
                wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                wizardDialog.open();
            }
            if (!eObjects.isEmpty()) {
                configuration.setObjects(eObjects);
                GenericLaunchConfigurationWizard wizard2 = new GenericLaunchConfigurationWizard(configuration, this.profile);
                WizardDialog wizardDialog2 = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard2);
                wizardDialog2.open();
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Code generation", (String)"Error while generating code", (IStatus)e.getStatus());
        }
    }

    private void manageSelection(List<ResourceSet> resourceSets, List<Resource> resources, List<EObject> objects, List<Object> selection) {
        for (Object o : selection) {
            IFile file;
            Resource resource;
            if (o instanceof EObject) {
                objects.add((EObject)o);
                continue;
            }
            if (o instanceof Resource) {
                resources.add((Resource)o);
                continue;
            }
            if (o instanceof ResourceSet) {
                resourceSets.add((ResourceSet)o);
                continue;
            }
            if (!(o instanceof IFile) || (resource = this.getResource(file = (IFile)o)) == null) continue;
            resources.add(resource);
        }
    }

    private Resource getResource(IFile file) {
        Resource model = null;
        if (file != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            model = resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
            return model;
        }
        return null;
    }
}

