/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets.parameters;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.polarsys.kitalpha.cadence.ui.api.dialog.IParameterManager;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.api.ParameterError;
import org.polarsys.kitalpha.composer.extension.points.ParameterizedComposerElement;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.launch.tabs.ComposerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterManager
implements IParameterManager {
    public String validParameter(Object parameter_p, Object container_p, Map<String, String> parameters_p) {
        ParameterError error;
        String result = "";
        Parameter param = (Parameter)parameter_p;
        String name = param.getName();
        Map<String, ParameterError> map = this.validAllParamaters((IConfigurationElement)container_p, parameters_p);
        if (map != null && (error = map.get(name)) != null) {
            result = this.formatter(name, error);
        }
        return result;
    }

    private String formatter(String name, ParameterError error) {
        String result = String.valueOf(name) + ":" + error.getReason();
        return result;
    }

    public Map<String, ParameterError> validAllParamaters(IConfigurationElement element_p, Map<String, String> map) {
        Map result = null;
        try {
            ParameterizedComposerElement parameterizedComposerElement = (ParameterizedComposerElement)element_p.createExecutableExtension("Class");
            result = parameterizedComposerElement.validateParameters(ComposerHelper.buildMapFromString(map, parameterizedComposerElement));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return result;
    }

    public String getName(Object o) {
        String string = null;
        if (o instanceof Parameter) {
            Parameter parameter = (Parameter)o;
            string = parameter.getName();
        }
        return string;
    }

    public String getDescription(Object o) {
        String string = null;
        if (o instanceof Parameter) {
            Parameter parameter = (Parameter)o;
            string = parameter.getDescription();
        }
        return string;
    }
}

