/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.menus;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.kitalpha.composer.api.NsURIAnalyzer;
import org.polarsys.kitalpha.composer.api.profiles.ComposerProfile;
import org.polarsys.kitalpha.composer.api.profiles.IComposerProfileRegistry;
import org.polarsys.kitalpha.composer.ui.Activator;
import org.polarsys.kitalpha.composer.ui.actions.LaunchComposerAction;
import org.polarsys.kitalpha.composer.ui.actions.LaunchFromProfileAction;
import org.polarsys.kitalpha.composer.ui.launch.CodeManagerLaunchConfigurationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenManagerContributionItem
extends CompoundContributionItem {
    private boolean enabled = false;

    public CodegenManagerContributionItem() {
    }

    public CodegenManagerContributionItem(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.getPopupMenu();
        boolean bl = this.enabled = !items.isEmpty();
        if (!this.enabled) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    public List<IContributionItem> getPopupMenu() {
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>();
        HashSet<ILaunchConfiguration> allConfigs = new HashSet<ILaunchConfiguration>();
        ISelectionProvider selectionProvider = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider();
        if (selectionProvider != null) {
            ISelection selection = selectionProvider.getSelection();
            List<Object> adaptedSelection = this.adaptSelection(selection);
            for (Object o : adaptedSelection) {
                allConfigs.addAll(this.getLaunchConfigurations(o));
            }
            for (ILaunchConfiguration launchConfig : allConfigs) {
                result.add((IContributionItem)new ActionContributionItem((IAction)new LaunchComposerAction(launchConfig)));
            }
            result.add((IContributionItem)new Separator());
            IWorkbenchPartSite serviceLocator = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
            String id = "org.eclipse.debug.ui.commands.from.composer";
            String commandId = "org.eclipse.debug.ui.commands.OpenRunConfigurations";
            CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)serviceLocator, id, commandId, 8);
            param.label = "Edit or setup configurations ...";
            CommandContributionItem i = new CommandContributionItem(param);
            result.add((IContributionItem)i);
            result.add((IContributionItem)new Separator());
            List<IAction> fromProfiles = this.getFromProfiles(adaptedSelection);
            if (fromProfiles != null && !fromProfiles.isEmpty()) {
                MenuManager profiles = new MenuManager("New configuration from a profile ...");
                for (IAction profileAction : fromProfiles) {
                    profiles.add((IContributionItem)new ActionContributionItem(profileAction));
                }
                result.add((IContributionItem)profiles);
            }
        }
        return result;
    }

    private List<IAction> getFromProfiles(List<Object> adaptedSelection) {
        TreeSet<ComposerProfile> profiles = new TreeSet<ComposerProfile>(new ComposerProfileComparator());
        for (Object o : adaptedSelection) {
            Collection<String> businessUris = new HashSet<String>();
            if (o instanceof IFile) {
                IFile file = (IFile)o;
                businessUris = NsURIAnalyzer.getNsURIs((File)file.getLocation().toFile());
            } else if (o instanceof EObject) {
                EObject object = (EObject)o;
                businessUris.add(object.eClass().getEPackage().getNsURI());
                for (EClass eClass : object.eClass().getEAllSuperTypes()) {
                    businessUris.add(eClass.getEPackage().getNsURI());
                }
            }
            for (String businessUri : businessUris) {
                profiles.addAll(IComposerProfileRegistry.INSTANCE.getBySemanticNsURI(businessUri));
            }
        }
        ArrayList<IAction> result = new ArrayList<IAction>();
        for (ComposerProfile profile : profiles) {
            result.add((IAction)new LaunchFromProfileAction(profile, adaptedSelection));
        }
        return result;
    }

    private Set<ILaunchConfiguration> getLaunchConfigurations(Object o) {
        HashSet<ILaunchConfiguration> result = new HashSet<ILaunchConfiguration>();
        if (o instanceof IFile) {
            IFile file = (IFile)o;
            File ioFile = file.getLocation().toFile();
            for (String uri : NsURIAnalyzer.getNsURIs((File)ioFile)) {
                try {
                    ILaunchConfiguration[] launchConfigurations = CodeManagerLaunchConfigurationHelper.getAllCodeManagerLaunchConfigurationsWithMMUri(uri);
                    result.addAll(new HashSet<ILaunchConfiguration>(Arrays.asList(launchConfigurations)));
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        } else if (o instanceof EObject) {
            ArrayList<EObject> eObjects = new ArrayList<EObject>(1);
            eObjects.add((EObject)o);
            String nsURI = ((EObject)o).eClass().getEPackage().getNsURI();
            ILaunchConfiguration[] launchConfigurations = new ILaunchConfiguration[]{};
            try {
                launchConfigurations = CodeManagerLaunchConfigurationHelper.getAllCodeManagerLaunchConfigurationsWithMMUri(nsURI);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            result.addAll(new HashSet<ILaunchConfiguration>(Arrays.asList(launchConfigurations)));
        }
        return result;
    }

    private List<Object> adaptSelection(ISelection selection) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Object adaptedObject = this.adaptObject(o);
                if (adaptedObject != null) {
                    result.add(adaptedObject);
                }
                ++n2;
            }
        }
        return result;
    }

    private Object adaptObject(Object o) {
        if (o instanceof IFile) {
            return o;
        }
        if (o instanceof EObject) {
            return o;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComposerProfileComparator
    implements Comparator<ComposerProfile> {
        private ComposerProfileComparator() {
        }

        @Override
        public int compare(ComposerProfile arg0, ComposerProfile arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }
}

