/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.registry;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.registry.RegistryHelper;
import org.polarsys.kitalpha.model.common.commands.registry.WorkflowType;

public class ModelCommandRegistry {
    private static Logger LOGGER = Logger.getLogger(ModelCommandRegistry.class);
    private Map<String, RegistryActionElement> registry = new HashMap<String, RegistryActionElement>();
    public static final ModelCommandRegistry INSTANCE = new ModelCommandRegistry();

    private ModelCommandRegistry() {
    }

    public Map<String, RegistryActionElement> initRegistry() {
        this.dispose();
        IExtension[] extensions = RegistryHelper.getAllExtensionsFor("org.polarsys.kitalpha.model.common.commands.definition");
        if (extensions != null && extensions.length > 0) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (config.getName().equals("command")) {
                        String id = config.getAttribute("id");
                        String finderId = config.getAttribute("scrutinizeId");
                        String className = config.getAttribute("class");
                        String workflow = config.getAttribute("workflow");
                        try {
                            if (className != null && !className.isEmpty()) {
                                String priorityStr = config.getAttribute("priority");
                                float priority = Float.parseFloat(priorityStr);
                                Object action = config.createExecutableExtension("class");
                                ModelCommand modelAction = (ModelCommand)action;
                                if (finderId != null && !finderId.isEmpty()) {
                                    modelAction.setModelAnalysisID(finderId);
                                }
                                modelAction.SetWorkflow(WorkflowType.getWorkflowEnumItemFromString(workflow));
                                this.registry.put(id, new RegistryActionElement(priority, modelAction));
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.registry;
    }

    public void dispose() {
        this.registry.clear();
    }

    public static class RegistryActionElement
    implements Comparable<RegistryActionElement> {
        private final float priority;
        private ModelCommand action;

        public RegistryActionElement(float priority, ModelCommand action) {
            this.priority = priority;
            this.action = action;
        }

        public float getPriority() {
            return this.priority;
        }

        public ModelCommand getAction() {
            return this.action;
        }

        @Override
        public int compareTo(RegistryActionElement arg0) {
            if (this.getPriority() - arg0.getPriority() < 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

