/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.detachment.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.polarsys.kitalpha.model.common.precondition.exception.InvalidPreconditionException;
import org.polarsys.kitalpha.model.common.precondition.runner.PreconditionRunner;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.Scrutineer;
import org.polarsys.kitalpha.model.detachment.ui.editor.DetachmentEditorInput;
import org.polarsys.kitalpha.model.detachment.ui.editor.ModelDetachment;
import org.polarsys.kitalpha.model.detachment.ui.internal.DetachmentResourceProviderUtil;

public class DetachmentHelper {
    public static void checkPreconditions(IFile airdIResource, IProgressMonitor monitor) throws InvalidPreconditionException {
        PreconditionRunner preconditionRunner = new PreconditionRunner();
        preconditionRunner.run((Object)airdIResource, monitor);
    }

    public static void openEditor(IFile airdIResource, IProgressMonitor monitor) throws PartInitException, InvalidPreconditionException {
        DetachmentHelper.checkPreconditions(airdIResource, monitor);
        Resource resource = DetachmentResourceProviderUtil.getResource(airdIResource);
        monitor.subTask("Scrutinizing : " + resource.getURI());
        Scrutineer.startScrutiny((Resource)resource);
        monitor.worked(1);
        monitor.done();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new DetachmentEditorInput(), (String)"org.polarsys.kitalpha.model.detachment.ui.editor");
        if (editor != null && editor instanceof ModelDetachment) {
            ModelDetachment modelDetachmentEditor = (ModelDetachment)editor;
            modelDetachmentEditor.initAndLaunchDetachmentAction(resource);
        }
    }
}

