/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.emfscheme.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class ModelReuseHelper {
    private static final String MODELREUSE_SCHEME_PREFIX = "modelreuse:/";

    public static URI createModelReuseURI(Resource resource) {
        return ModelReuseHelper.createModelReuseURI(MODELREUSE_SCHEME_PREFIX, resource);
    }

    private static URI createModelReuseURI(String protocolName, Resource resource) {
        String elementID = resource.getId();
        List tags = resource.getTags();
        String finalResult = "Id=" + elementID;
        int i = 0;
        if (resource.getName() != null) {
            finalResult = String.valueOf(finalResult) + " Name=" + resource.getName();
        }
        if (resource.getDomain() != null) {
            finalResult = String.valueOf(finalResult) + " Domain=" + resource.getDomain();
        }
        if (resource.getVersion() != null) {
            finalResult = String.valueOf(finalResult) + " Version=" + resource.getVersion();
        }
        if (tags != null) {
            finalResult = String.valueOf(finalResult) + " Tags=[";
            for (String tag : tags) {
                int size = tags.size();
                finalResult = ++i == size ? String.valueOf(finalResult) + tag : String.valueOf(finalResult) + tag + ";";
            }
            finalResult = String.valueOf(finalResult) + "]";
        }
        URI result = URI.createURI((String)(String.valueOf(protocolName) + finalResult));
        return result;
    }

    public static List<URI> findModelsURIAccordingToCriteria(SearchCriteria criteria) {
        ArrayList<URI> foundModels = new ArrayList<URI>();
        List<Resource> resourceSelected = ModelReuseHelper.findModelsAccordingToCriteria(criteria);
        for (Resource resource : resourceSelected) {
            URI modelResourceURI = null;
            modelResourceURI = ModelReuseHelper.createModelReuseURI(MODELREUSE_SCHEME_PREFIX, resource);
            foundModels.add(modelResourceURI);
        }
        return foundModels;
    }

    public static List<Resource> findModelsAccordingToCriteria(SearchCriteria criteria) {
        Resource[] resourceSelectedPlatform;
        Resource[] resourceSelectedWorkspace;
        ResourceHelper resourceHelperPlatform = ResourceReuse.createPlatformHelper();
        ResourceHelper resourceHelperWorkspace = ResourceReuse.createWorkspaceHelper();
        ArrayList<Resource> resourceSelected = new ArrayList<Resource>();
        Resource[] resourceArray = resourceSelectedWorkspace = resourceHelperWorkspace.getResources(criteria);
        int n = resourceSelectedWorkspace.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            resourceSelected.add(resource);
            ++n2;
        }
        Resource[] resourceArray2 = resourceSelectedPlatform = resourceHelperPlatform.getResources(criteria);
        int n3 = resourceSelectedPlatform.length;
        n = 0;
        while (n < n3) {
            Resource resource = resourceArray2[n];
            boolean resourceAlreadyFound = false;
            for (Resource resourceInResourceSelected : resourceSelected) {
                if (!resourceInResourceSelected.getName().equals(resource.getName())) continue;
                resourceAlreadyFound = true;
            }
            if (!resourceAlreadyFound) {
                resourceSelected.add(resource);
            }
            ++n;
        }
        return resourceSelected;
    }
}

