/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.scheduler.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.transposer.analyzer.graph.Edge;
import org.polarsys.kitalpha.transposer.analyzer.graph.Graph;
import org.polarsys.kitalpha.transposer.analyzer.graph.Vertex;
import org.polarsys.kitalpha.transposer.scheduler.api.ITransposerTask;
import org.polarsys.kitalpha.transposer.scheduler.exceptions.CycleException;
import org.polarsys.kitalpha.transposer.scheduler.scheduler.AbstractCycleWiseScheduler;
import org.polarsys.kitalpha.transposer.scheduler.scheduler.AbstractTopologicalSorter;
import org.polarsys.kitalpha.transposer.scheduler.scheduler.impl.GenericTopologicalSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericScheduler
extends AbstractCycleWiseScheduler {
    private Set<Vertex<?>> _visited;
    private Set<Vertex<?>> _notVisited;
    private Set<Edge<?>> _backTracks;
    private List<ITransposerTask<Vertex<?>>> _scheduleResult;
    private List<Edge<?>> _browsedPath;
    private Set<LinkedList<Edge<?>>> _foundCycles;
    private IProgressMonitor _monitor = null;
    private int _monitorSize;

    public GenericScheduler() {
        this.init();
    }

    public GenericScheduler(Graph model_p) {
        this.setModel(model_p);
        this.init();
    }

    private void depthFirstVisitGlobal() {
        List<Vertex<?>> summits = this.getAllModelSummits();
        for (Vertex<?> currentSummit : summits) {
            this.depthFirstVisitLocalWithCycleSearch(currentSummit);
        }
        this.identifyBacktracksFromCycles();
    }

    private void depthFirstVisitLocalWithCycleSearch(Vertex<?> currentVertex) {
        if (this._monitor != null) {
            this._monitor.subTask("Visiting vertex " + currentVertex.getName());
            if (this._monitorSize != 0) {
                this._monitor.worked(1 / this._monitorSize);
            }
        }
        EList currentVertexEdges = currentVertex.getOutgoingEdges();
        for (Edge currentEdge : currentVertexEdges) {
            if (this._browsedPath.contains(currentEdge)) continue;
            Vertex nextVertex = currentEdge.getTarget();
            int index = this.indexOfVertexInPath(this._browsedPath, nextVertex);
            if (index > -1 || nextVertex == currentVertex) {
                LinkedList currentCycle = new LinkedList();
                if (index > -1) {
                    int i = index;
                    while (i < this._browsedPath.size()) {
                        currentCycle.add(this._browsedPath.get(i));
                        ++i;
                    }
                }
                currentCycle.add(currentEdge);
                if (!this.isNewCycle(currentCycle)) continue;
                this._foundCycles.add(currentCycle);
                continue;
            }
            if (this.isVisited(currentVertex)) continue;
            this._browsedPath.add(currentEdge);
            this.depthFirstVisitLocalWithCycleSearch(nextVertex);
        }
        this.setVisited(currentVertex);
        if (this._browsedPath.size() > 0) {
            this._browsedPath.remove(this._browsedPath.size() - 1);
        }
    }

    private boolean isNewCycle(LinkedList<Edge<?>> currentCycle_p) {
        for (LinkedList<Edge<Edge<?>>> linkedList : this._foundCycles) {
            if (linkedList.size() != currentCycle_p.size() || !linkedList.containsAll(currentCycle_p)) continue;
            return false;
        }
        return true;
    }

    private List<Vertex<?>> getAllModelSummits() {
        ArrayList summits = new ArrayList();
        for (Vertex vertex : this._model.getVertices()) {
            if (!vertex.isHotSpot()) continue;
            summits.add(vertex);
        }
        return summits;
    }

    @Override
    public Set<Edge<?>> getBackTracks() {
        return this._backTracks;
    }

    public Set<LinkedList<Edge<?>>> getFoundCycles() {
        return this._foundCycles;
    }

    @Override
    public Set<Vertex<?>> getNotVisited() {
        return this._notVisited;
    }

    @Override
    public List<ITransposerTask<Vertex<?>>> getScheduleResult() {
        return this._scheduleResult;
    }

    @Override
    public Set<Vertex<?>> getVisited() {
        return this._visited;
    }

    private void identifyBacktracksFromCycles() {
        for (LinkedList<Edge<?>> currentCycle : this._foundCycles) {
            boolean bl;
            boolean bl2;
            if (currentCycle.size() == 2) {
                for (Edge edge : currentCycle) {
                    if (this._backTracks.contains(edge) || edge.isCritical()) continue;
                    this._backTracks.add(edge);
                }
                continue;
            }
            boolean bl3 = false;
            for (Edge edge : currentCycle) {
                if (!this._backTracks.contains(edge)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            boolean bl4 = false;
            Iterator iterator = currentCycle.iterator();
            while (iterator.hasNext() && !bl) {
                Edge currentEdge = (Edge)iterator.next();
                if (currentEdge.isCritical()) continue;
                this._backTracks.add(currentEdge);
                bl = true;
            }
            if (bl) continue;
            System.out.println("Unbreakable cycle " + currentCycle.size() + " elements)");
        }
    }

    private int indexOfVertexInPath(List<Edge<?>> path, Vertex<?> vertex) {
        int i = 0;
        for (Edge<?> edge : path) {
            if (edge.getSource() == vertex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void init() {
        this._visited = new LinkedHashSet();
        this._notVisited = new HashSet();
        this._backTracks = new HashSet();
        this._foundCycles = new HashSet();
        this._browsedPath = new ArrayList();
        this._scheduleResult = new LinkedList();
    }

    @Override
    public void dispose() {
        this._visited = null;
        this._notVisited = null;
        this._backTracks = null;
        this._foundCycles = null;
        this._browsedPath = null;
        this._scheduleResult = null;
        this._monitor = null;
    }

    private boolean isVisited(Vertex<?> t) {
        return this._visited.contains(t);
    }

    private void markAllAsNotVisited() {
        this._notVisited.addAll((Collection<Vertex<?>>)this._model.getVertices());
        this._visited.clear();
    }

    @Override
    public void schedule(Comparator<Vertex<?>> comparator_p, IProgressMonitor monitor_p) {
        this.init();
        this.markAllAsNotVisited();
        if (monitor_p != null) {
            this._monitor = monitor_p;
            this._monitorSize = this._notVisited.size();
            monitor_p.beginTask("Transposer Scheduling", 3);
            monitor_p.subTask("Cycle search");
        }
        this.depthFirstVisitGlobal();
        try {
            this.setTopologicalSorter(this.getDefaultSorter());
            this.getTopologicalSorter().sort(comparator_p, monitor_p);
            this._scheduleResult = this.getTopologicalSorter().getWork(monitor_p);
            this.getTopologicalSorter().dispose();
        }
        catch (CycleException e) {
            e.printStackTrace();
        }
    }

    public AbstractTopologicalSorter getDefaultSorter() {
        return new GenericTopologicalSorter(this._visited, this._backTracks);
    }

    private void setVisited(Vertex<?> t) {
        if (!this.isVisited(t)) {
            this._visited.add(t);
            this._notVisited.remove(t);
        }
    }
}

