/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph;

import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.ArchitectureFramework;
import org.polarsys.kitalpha.ad.af.dsl.as.model.afdesc.Viewpoints;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationEdge;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationNode;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.viewpoint.PlatformViewpointHelper;

public class GenerationGraph {
    private Vector<GenerationNode> _owned_GenerationNodes = new Vector();
    private Vector<GenerationEdge> _owned_GenerationEdges = new Vector();

    public GenerationGraph(ArchitectureFramework architectureFramework) {
        if (architectureFramework != null) {
            this.createGraphNodes(architectureFramework);
            this.createGraphEdges();
        }
    }

    public GenerationGraph clone() {
        GenerationGraph theClone = new GenerationGraph(null);
        theClone.getOwnedEdges().addAll((Vector)this.getOwnedEdges().clone());
        theClone.getOwnedNodes().addAll((Vector)this.getOwnedNodes().clone());
        return theClone;
    }

    public void remove(GenerationNode node) {
        Vector<GenerationEdge> concernedEdges = new Vector<GenerationEdge>();
        for (GenerationEdge edge : this.getOwnedEdges()) {
            if (edge.getSourceNode().equals(node) && !concernedEdges.contains(edge)) {
                concernedEdges.add(edge);
            }
            if (!edge.getTargetNode().equals(node) || concernedEdges.contains(edge)) continue;
            concernedEdges.add(edge);
        }
        for (GenerationEdge cEdge : concernedEdges) {
            this.remove(cEdge);
        }
        this.getOwnedNodes().remove(node);
    }

    public void remove(GenerationEdge edge) {
        if (this.getOwnedEdges().contains(edge)) {
            this.getOwnedEdges().remove(edge);
        }
    }

    private void createGraphEdges() {
        for (GenerationNode node : this._owned_GenerationNodes) {
            EList dependencies;
            EList parents = node.getViewpoint().getParents();
            if (parents != null && parents.size() > 0) {
                for (Viewpoint parent : parents) {
                    GenerationNode target_node = this.getNode(parent);
                    if (target_node == null) continue;
                    GenerationEdge edge = new GenerationEdge();
                    edge.setKind(GenerationEdge.ViewpointLinkKind.PARENT);
                    edge.setSourceNode(node);
                    edge.setTargetNode(target_node);
                    this._owned_GenerationEdges.add(edge);
                }
            }
            if ((dependencies = node.getViewpoint().getDependencies()) == null || dependencies.size() <= 0) continue;
            for (Viewpoint dependencie : dependencies) {
                GenerationNode target_node = this.getNode(dependencie);
                if (target_node == null) continue;
                GenerationEdge edge = new GenerationEdge();
                edge.setKind(GenerationEdge.ViewpointLinkKind.DEPENDECIES);
                edge.setSourceNode(node);
                edge.setTargetNode(target_node);
                this._owned_GenerationEdges.add(edge);
            }
        }
    }

    public Vector<GenerationNode> getReferencingNodes(GenerationNode node) {
        Vector<GenerationNode> result = new Vector<GenerationNode>();
        for (GenerationEdge edge : this.getOwnedEdges()) {
            if (!edge.getTargetNode().equals(node) || !result.contains(edge.getSourceNode())) continue;
            result.add(edge.getSourceNode());
        }
        return result;
    }

    public Vector<GenerationNode> getLeafs() {
        Vector<GenerationNode> result = new Vector<GenerationNode>();
        for (GenerationNode node : this.getOwnedNodes()) {
            if (!this.isIsolatedNode(node)) continue;
            result.add(node);
        }
        Vector<GenerationNode> targetedNodes = new Vector<GenerationNode>();
        for (GenerationEdge edge : this.getOwnedEdges()) {
            GenerationNode node = edge.getTargetNode();
            if (targetedNodes.contains(node)) continue;
            targetedNodes.add(node);
        }
        for (GenerationNode node : targetedNodes) {
            boolean isLeaf = true;
            for (GenerationEdge edge : this.getOwnedEdges()) {
                if (!edge.getSourceNode().equals(node)) continue;
                isLeaf = false;
                break;
            }
            if (!isLeaf || result.contains(node)) continue;
            result.add(node);
        }
        return result;
    }

    public Vector<GenerationNode> getNeighbors(GenerationNode node) {
        Vector<GenerationNode> result = new Vector<GenerationNode>();
        for (GenerationEdge edge : this._owned_GenerationEdges) {
            if (!edge.getSourceNode().equals(node)) continue;
            result.add(edge.getTargetNode());
        }
        return result;
    }

    private void createGraphNodes(ArchitectureFramework architectureFramework) {
        Viewpoints vps = architectureFramework.getAf_viewpoints();
        if (vps != null) {
            for (Viewpoint viewpoint : vps.getOwned_viewpoints()) {
                EList vpDependecies;
                this.includeViewpointToGraph(viewpoint);
                EList vpParents = viewpoint.getParents();
                if (vpParents != null && vpParents.size() > 0) {
                    for (Viewpoint vp : vpParents) {
                        this.includeViewpointToGraph(vp);
                    }
                }
                if ((vpDependecies = viewpoint.getDependencies()) == null || vpDependecies.size() <= 0) continue;
                for (Viewpoint vp : vpDependecies) {
                    this.includeViewpointToGraph(vp);
                }
            }
        }
    }

    private void includeViewpointToGraph(Viewpoint viewpoint) {
        GenerationNode node;
        if (!PlatformViewpointHelper.isAFViewpointAvailable((Viewpoint)viewpoint) && (node = this.getGenerationNode(viewpoint)) == null) {
            node = new GenerationNode(viewpoint);
            this._owned_GenerationNodes.add(node);
        }
    }

    public boolean isEmpty() {
        return this.getOwnedNodes().isEmpty();
    }

    public boolean isLastNode(GenerationNode generationNode) {
        int nodeCount;
        int nodeIndex = this._owned_GenerationNodes.indexOf(generationNode);
        return nodeIndex == (nodeCount = this._owned_GenerationNodes.size()) - 1;
    }

    private GenerationNode getGenerationNode(Viewpoint viewpoint) {
        for (GenerationNode generationNode : this._owned_GenerationNodes) {
            if (!generationNode.getViewpoint().equals(viewpoint)) continue;
            return generationNode;
        }
        return null;
    }

    public GenerationNode getNode(Viewpoint viewpoint) {
        for (GenerationNode generationNode : this._owned_GenerationNodes) {
            if (!EcoreUtil.equals((EObject)viewpoint, (EObject)generationNode.getViewpoint())) continue;
            return generationNode;
        }
        return null;
    }

    public boolean isIsolatedNode(GenerationNode node) {
        for (GenerationEdge edge : this.getOwnedEdges()) {
            if (!edge.getSourceNode().equals(node) && !edge.getTargetNode().equals(node)) continue;
            return false;
        }
        return true;
    }

    public Vector<GenerationNode> getOwnedNodes() {
        return this._owned_GenerationNodes;
    }

    public Vector<GenerationEdge> getOwnedEdges() {
        return this._owned_GenerationEdges;
    }

    public void print() {
        System.out.println("Nodes");
        for (GenerationNode node : this._owned_GenerationNodes) {
            System.out.print(node.getName());
            if (!this.isLastNode(node)) {
                System.out.print(", ");
                continue;
            }
            System.out.println(" ");
        }
        System.out.println("Edges");
        for (GenerationEdge edge : this._owned_GenerationEdges) {
            System.out.print(edge.getSourceNode().getName());
            switch (edge.getKind()) {
                case DEPENDECIES: {
                    System.out.print("=>");
                    break;
                }
                case PARENT: {
                    System.out.print("->");
                }
            }
            System.out.print(edge.getTargetNode().getName());
            System.out.print(" | ");
        }
        System.out.println();
    }
}

