/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.validatation.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.AbstractPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.Activity;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.ActivityExplorerItem;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.Page;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.Section;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.model.ViewpointActivityExplorer.ViewpointActivityExplorer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.activityexplorer.validatation.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.IAdditionalConstraint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.validation.extension.ValidationStatus;

public class ActivityExplorerItemUniqueIDConstraint
implements IAdditionalConstraint {
    public boolean isObjectInScope(Object object) {
        return object instanceof ActivityExplorerItem;
    }

    public ValidationStatus validationRules(Object data) {
        String id;
        ActivityExplorerItem item = (ActivityExplorerItem)data;
        ViewpointActivityExplorer viewpointActivityExplorer = this.getViewpointActivityExplorer(item);
        List<String> ids = this.getAllActivityExplorerIdsExceptItem(viewpointActivityExplorer, item);
        if (ids.contains(id = item.getActivityExplorerItemID())) {
            return ValidationStatus.Error;
        }
        return ValidationStatus.Ok;
    }

    public String getMessage(ValidationStatus status, Object object) {
        ActivityExplorerItem item = (ActivityExplorerItem)object;
        String name = item.getName();
        return Messages.bind((String)Messages.DuplicatedActivityExplorerId, (Object)name);
    }

    protected ViewpointActivityExplorer getViewpointActivityExplorer(ActivityExplorerItem item) {
        EObject itemCcontainer = item.eContainer();
        if (!(itemCcontainer instanceof ViewpointActivityExplorer)) {
            while (itemCcontainer != null && !(itemCcontainer instanceof ViewpointActivityExplorer)) {
                itemCcontainer = itemCcontainer.eContainer();
            }
        }
        if (itemCcontainer != null) {
            return (ViewpointActivityExplorer)itemCcontainer;
        }
        throw new RuntimeException(Messages.Validation_Runtime_CantLocateViewpointActivityExplorer);
    }

    protected List<String> getAllActivityExplorerIdsExceptItem(ViewpointActivityExplorer viewpointActivityExplorer, ActivityExplorerItem item) {
        ArrayList<String> ids = new ArrayList<String>();
        List<Page> pages = this.getAllPages(viewpointActivityExplorer);
        if (pages.contains(item)) {
            pages.remove(item);
        }
        for (Page page : pages) {
            String id = page.getActivityExplorerItemID();
            if (id == null || id.trim().length() <= 0) continue;
            ids.add(id);
        }
        List<Section> sections = this.getAllSections(viewpointActivityExplorer);
        if (sections.contains(item)) {
            sections.remove(item);
        }
        for (Section section : sections) {
            String id = section.getActivityExplorerItemID();
            if (id == null || id.trim().length() <= 0) continue;
            ids.add(id);
        }
        List<Activity> activities = this.getActivities(viewpointActivityExplorer);
        if (activities.contains(item)) {
            activities.remove(item);
        }
        for (Activity activity : activities) {
            String id = activity.getActivityExplorerItemID();
            if (id == null || id.trim().length() <= 0) continue;
            ids.add(id);
        }
        return ids;
    }

    protected List<Page> getAllPages(ViewpointActivityExplorer viewpointActivityExplorer) {
        ArrayList<Page> result = new ArrayList<Page>();
        EList abstractPages = viewpointActivityExplorer.getOwnedPages();
        for (AbstractPage abstractPage : abstractPages) {
            if (!(abstractPage instanceof Page)) continue;
            result.add((Page)abstractPage);
        }
        return result;
    }

    protected List<Section> getAllSections(ViewpointActivityExplorer viewpointActivityExplorer) {
        ArrayList<Section> result = new ArrayList<Section>();
        List<Page> pages = this.getAllPages(viewpointActivityExplorer);
        for (Page page : pages) {
            EList pageSections = page.getOwnedSections();
            if (pageSections.isEmpty()) continue;
            result.addAll((Collection<Section>)pageSections);
        }
        return result;
    }

    protected List<Activity> getActivities(ViewpointActivityExplorer viewpointActivityExplorer) {
        ArrayList<Activity> result = new ArrayList<Activity>();
        List<Section> sections = this.getAllSections(viewpointActivityExplorer);
        for (Section section : sections) {
            EList sectionActivities = section.getOwnedActivities();
            if (sectionActivities.isEmpty()) continue;
            result.addAll((Collection<Activity>)sectionActivities);
        }
        return result;
    }
}

