/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.activityexplorer.internal;

import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.NamedElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.java.JDTUtility;

public class JavaNamingConvention {
    public static String getJavaPackageNameFor(String basePackage, JavaUseContext context) {
        if (context == null) {
            throw new IllegalArgumentException("[VPDSL - Java Class Naming Convention] JavaClassUseContext is mandatory");
        }
        String s_context = context.toString();
        String javaPackageName = basePackage != null && !basePackage.isEmpty() ? String.valueOf(basePackage) + "." + s_context : s_context;
        javaPackageName = JDTUtility.getValidPackageName((String)javaPackageName);
        return javaPackageName;
    }

    public static String getJavaClassFQNFor(String basePackage, NamedElement element, JavaUseContext context) {
        String javaPackageNameFor = JavaNamingConvention.getJavaPackageNameFor(basePackage, context);
        String javaClassNameFor = JavaNamingConvention.getJavaClassNameFor(element, context);
        return String.valueOf(javaPackageNameFor) + '.' + javaClassNameFor;
    }

    public static String getJavaClassNameFor(NamedElement element, JavaUseContext context) {
        if (context == null) {
            throw new IllegalArgumentException("[VPDSL - Java Class Naming Convention] JavaClassUseContext is mandatory");
        }
        if (element == null) {
            throw new IllegalArgumentException("[VPDSL - Java Class Naming Convention] Null element are not accepted");
        }
        String name = element.getName();
        if (name == null || name != null && name.isEmpty()) {
            throw new IllegalArgumentException("[VPDSL - Java Class Naming Convention] No named element are not accepted");
        }
        String javaClassName = String.valueOf(name) + context.toString();
        if (context.equals((Object)JavaUseContext.Predicate)) {
            String modelElementClassName = element.eClass().getName();
            char firstLetter = modelElementClassName.charAt(0);
            javaClassName = String.valueOf(firstLetter) + javaClassName;
        }
        javaClassName = JDTUtility.getValidClassName((String)javaClassName);
        return javaClassName;
    }

    public static enum JavaUseContext {
        Page("Page"),
        Activity("Activity"),
        Predicate("Predicate");

        private String context;

        private JavaUseContext(String context) {
            this.context = context;
        }

        public String toString() {
            return this.context;
        }
    }
}

